package datab;

# Nacteni vyzadovanych knihoven
use DBI;
use Text::CSV;
use Term::ANSIColor;	# Modul pro formatoveni chyb barva/tucne
use Text::NSP::Measures::2D::Fisher2::twotailed;	# Statistic - Fischer/Exact test {instalation Text::NSP}

###################################################################################################
############################### BASIC DATABASE FUNCTIONS ##########################################
###################################################################################################
#BASIC 1# - Access to database  - function(host, database, user, password)
#Return: databaze if success, else undef value
sub pristup 
{
	#1 Get local variables
	my $host = shift;	
	my $dbname = shift;
	my $dbuser = shift;
	my $dbheslo = shift;
	#2 Get connestion to DB
	my $databaze = DBI->connect("dbi:mysql:dbname=$dbname", $dbuser, $dbheslo);
	#3 Verify connection
	if(!(defined($databaze)))
	{
		print STDERR color("red"), "ERROR: Problem in connecting with database name $dbname. Please check the manual and your user privilegies.\n", color("reset");
		&err_message("ERROR: Problem in connecting with database name $dbname. Please check the manual and your user privilegies.\n");
		return undef;
	}
	#4 If connection established give DB
	return $databaze;
}


#BASIC 2# - Create database - function(host, user, password, name_database)
#Return: 0 if problem, 1 if OK
sub create_dat 
{
	#1 Local variables
	my $host = shift;	
	my $user = shift;
	my $heslo = shift;	
	my $jmeno = shift;
	my $dbs;			# DB system
	
	#2 Connect to DBS MYSQL
	if(!($dbs = DBI->connect("DBI:mysql:host=$host;", $user, $heslo))) 
	{
		print STDERR color("red"), "ERROR: Problem in connecting with database system. Please check the manual and your user privilegies.\n", color("reset");
		&err_message("ERROR: Problem in connecting with database system. Please check the manual and your user privilegies.\n");
		return 0;
	}
	
	#3 Create database
	if($dbs->do("CREATE DATABASE $jmeno")) 
	{
		#A Disconnecs to DBS
		$dbs->disconnect;
		#B Create DB structure
		if(&create_struct_dat($host, $user, $heslo, $jmeno)) 
		{
			return 1;
		}
		else 
		{
			return 0; 
		}
	}
	else 
	{
		$dbs->disconnect;
		return 0;
	}
}

#BASIC 3# - Delete existing database - function (host, user, password, name)
#Return: 1 - database removed, 0 - remove unsuccesfull
sub delete_dat 
{
	#1 Local variables
	my $host = shift;
	my $user = shift;
	my $heslo = shift;
	my $datab = shift;	# Name of database
	my $dbs;				# Database system
	
	#2 Conecting to database system	
	if(!($dbs = DBI->connect("DBI:mysql:host=$host;", $user, $heslo))) 
	{
		print STDERR color("red"), "ERROR: Problem in connecting with database system. Please check the manual and your user privilegies.\n", color("reset");
		&err_message("ERROR: Problem in connecting with database system. Please check the manual and your user privilegies.\n");
		return 0;
	}
	
	#3 User confirmation
	print STDERR "Are you alredy sure to delete database. Yes/No\n";
	
	$potvrzeni = <STDIN>; 
	$potvrzeni =~ s/\n//g;
	
	#4 If confirmation NO
	if (!($potvrzeni eq 'Yes' || $potvrzeni eq 'Y' || $potvrzeni eq 'y' || $potvrzeni eq 'yes')) 
	{
		print STDERR color("green"), "MESSAGE: Remove database name $datab canceled.\n", color("reset");
		return 2;
	}
	
	#5 Remove database YES
	if ($dbs->do("DROP DATABASE $datab")) 
	{
		$dbs->disconnect;
		print STDERR color("green"), "MESSAGE: Database name $datab is succesfully deleted.\n", color("reset");
		return 1;
	}
	else 
	{
		$dbs->disconnect;
		print STDERR color("red"), "ERROR: Unexpected problem with delete database. Please check you parameters.\n", color("reset");
		&err_message("ERROR: Unexpected problem with delete database. Please check you parameters.\n");
		return 0;
	}
}

#BASIC 4# - Show databases - function(host, user, password)
#Return: 0 if problem, 1 if success without results, 2 database founded 
sub show_databases 
{
	#1 Local variables
	my $host = shift;
	my $user = shift;
	my $heslo = shift;
	my $dbs;				# Database system
	my $db_temp;			# Temp database for verify
	my $ct = 0;			# Counter of databases
	my $db_list = 0;		# List of DB
	my $db_name = "";	# DB name
	
	#2 Get acess to DBS
	if(!($dbs = DBI->connect("DBI:mysql:host=$host;", $user, $heslo))) 
	{
		print STDERR color("red"), "ERROR: Problem in connecting with database system. Please check the manual and your user privilegies.\n", color("reset");
		&err_message("ERROR: Problem in connecting with database system. Please check the manual and your user privilegies.\n");
		return 0;
	}
	
	#3 Get list of DB
	$db_list = $dbs->prepare("SHOW DATABASES;");
	$db_list->execute;
	
	#4 If DB has correct structure
	if ($db_list) 
	{
		while(($db_name) = $db_list->fetchrow_array) 
		{
			$db_temp = &pristup($host, $db_name, $user, $heslo);
			if (!(defined($db_temp))) 
			{
				next;
			}
			elsif (&verify_datab_structure($db_temp,1)) 
			{
				$ct = $ct + 1;
				print STDERR color("green"), "MESSAGE: Database $db_name founded with right structure.\n", color("reset");
				# Get control count
				&control_count($db_temp, $db_name);
				# Disconnect DB
				$db_temp->disconnect;
			}
			else 
			{
				$db_temp->disconnect;
			}	
		}
		
		#5 Print exit message
		print STDERR color("green"), "MESSAGE: Find $ct databases avaiable for work with program.\n", color("reset");
		&warr_message("MESSAGE: Find $ct databases avaiable for work with program.\n");
		$dbs->disconnect;
		return 2;
	}
	else 
	{
		$dbs->disconnect;
		print STDERR color("blue"), "MESSAGE: There is no database for verifying.\n", color("reset");
		&warr_message("MESSAGE: There is no database for verifying.\n");
		return 1;
	}
}

#BASIC 5# - Verify structure of database - function(database)
#Return: 0 if not right structure, 1 if right strucure
sub verify_datab_structure 
{
	#1 Local variables
	my $db = shift;
	my $show = shift;
	my $prikaz = $db->prepare("SHOW TABLES;");
	my $a = 0;										# Counter of tables
	my $temp_table;									# Temp tables
	
	#2 Get names of tables
	$prikaz->execute();
	
	#3 Verify tables
	while (($temp_table) = $prikaz->fetchrow_array) 
	{
		# Increase counter
		$a++ if (	$temp_table eq '1_Sequence' || $temp_table eq '2_Hits' ||
				$temp_table eq '6_GO_parse' ||
				$temp_table eq '5_term2term' || $temp_table eq '3_InterProScan_data' ||
				$temp_table eq '4_term' || $temp_table eq '7_DEG' ||
	 			$temp_table eq '8_GO_analysis' || $temp_table eq '9_GO_results');
	}
	
	#4 Structure control
	if (($a == 9) && $show)
	{
		return 1;	
	}
	elsif ($show)
	{
		return 0;
	}
	elsif ($a == 9) 
	{
		print STDERR color("green"), "MESSAGE: Database structure is correct.\n", color("reset");
		&warr_message("MESSAGE: Database structure is correct.\n");
		return 1;
	}
	else 
	{
		print STDERR color("red"), "ERROR: Structure database is incorrect. Please check the manual.\n", color("reset");
		&err_message("ERROR: Structure database is incorrect. Please check the manual.\n");
		return 0;
	}
}

#BASIC 6# - Create structure of tables in DB - function(host, user, password, name_db)
#Return: 0 if problem, 1 if OK
sub create_struct_dat 
{
	#1 Set local variables
	my $host = shift;
	my $user = shift;
	my $heslo = shift;
	my $jmeno_db = shift;
	my $db;					# DB connection
	
	#2 Create connection with DB
	$db = &pristup($host, $jmeno_db, $user, $heslo);
	if (!(defined($db))) 
	{
		return 0;
	}
	
	#3 Create tables
	return 0 unless $db->do("CREATE TABLE 1_Sequence (
			1_seq_name char(100) primary key, 
			1_length integer,
			1_sequence varchar(15000),
			1_status integer default 0);");
	return 0 unless $db->do("CREATE TABLE 2_Hits (
			2_seq_name char(100), 
			2_hit_definition char(200), 
			2_hit_accession char(20), 
			2_hit_len double, 
			2_bit_score integer, 
			2_score integer default null, 
			2_evalue double default null, 
			2_query_from integer default null, 
			2_query_to integer default null, 
			2_identity integer default null, 
			2_positive integer default null, 
			2_align_length integer default null,
			CONSTRAINT duplic_hit UNIQUE NUCLUSTERED (2_seq_name, 2_hit_definition, 2_hit_accession, 2_hit_len, 2_query_from, 2_query_to));");
	return 0 unless $db->do("CREATE TABLE 6_GO_parse (
			6_seq_name char(100), 
			6_entry_ac char(20), 
			6_GO_number char(255),
			CONSTRAINT duplic_GO_parse UNIQUE NOCLUSTERED (6_seq_name, 6_GO_number));"); 
	return 0 unless $db->do("CREATE TABLE 5_term2term (
			5_id integer primary key, 
			5_relationship_type_id integer, 
			5_term1_id integer, 
			5_term2_id integer, 
			5_complete integer);");
	return 0 unless $db->do("CREATE TABLE 3_InterProScan_data (
			3_seq_name char(100),
			3_database char(50),
			3_score double default null,
			3_evalue double default null,
			3_signature_name char(100),
			3_signature_desc char(255),
			3_signature_ac char(255),
			3_entry_type char(255),
			3_entry_name char(255),
			3_entry_desc char(255),
			3_entry_ac char(50),
			CONSTRAINT duplic_IPR UNIQUE NUCLUSTERED (3_seq_name, 3_database, 3_signature_name, 3_signature_ac, 3_entry_name, 3_entry_ac));");
	return 0 unless $db->do("CREATE TABLE 4_term (
			4_id integer primary key, 
			4_level integer default 0,
			4_group integer default 0,
			4_name char(255), 
			4_term_type char(55), 
			4_acc char(255), 
			4_is_obsolete integer, 
			4_is_root integer, 
			4_is_relation integer);");
	return 0 unless $db->do("CREATE TABLE 7_DEG (
			7_seq_name char(100) primary key, 
			7_baseMean double default null,
			7_log2FoldChange double default null,
			7_pvalue double default null,
			7_padj double default null);");
	return 0 unless $db->do("CREATE TABLE 8_GO_analysis (
			8_seq_name char(100) not null,
			8_term_id integer not null,
			8_term_level integer default 0,
			CONSTRAINT duplic_GO UNIQUE NOCLUSTERED (8_seq_name, 8_term_id));");
	return 0 unless $db->do("CREATE TABLE 9_GO_results (
			9_seq_name char(100) not null,
			9_term_id integer not null,
			9_log2FoldChange double default 0,
			9_transcriptome_loc integer default 1,
			9_DEG_loc integer default 0,
			CONSTRAINT duplic_resGO UNIQUE NOCLUSTERED (9_seq_name, 9_term_id));");
		
	#4 Disconnect DB and return success value
	$db->disconnect;
	return 1;
}

#BASIC 7# - Delete data from table - function(db, tab_name)
#Return: 0 if problem, 1 if OK
sub del_tab 
{
	#1 Local variables
	my $db = shift;
	my $tab = shift;
	#2 Delete data from table
	if ($db->do("DELETE FROM $tab")) 
	{
		return 1;
	}
	#3 Error
	print STDERR color("red"), "ERROR: Problem with deleting data from database table $tab.\n", color("reset");
	&err_message("ERROR: Problem with deleting data from database table $tab.\n");
	return 0;
}

#BASIC 8# - Get number of records
#Return: count of records or undef value
sub count_records 
{
	#1 Local variables
	my $db = shift;
	my $tab = shift;
	my $count = 0;
	
	#2 Get count of records
	$count = $db->do('SELECT * FROM ' . $tab . ';');
	
	#3 Give result
	if (defined($count)) 
	{
		return $count;
 	}
	else 
	{
		return undef;
	}
}

#BASIC 9# - Get numbers from tables of database
#Return: 1 if succes, 0 if errror
sub control_count 
{
	#1 Get variables
	my $db = shift;
	my $db_name = shift;
	my $c_err = 0;
	my $count = undef;
	
	#2 Print introduction message
	print STDERR "In database name $db_name is now: \n";
	
	#3 Table SEKVENCE
	$count = &count_records($db,"1_Sequence");
	if (defined($count)) 
	{
		print STDERR "$count records in table 1_Sequence\n";
		&warr_message("$count records in table 1_Sequence\n");
	}
	else 
	{
		$c_err++;
		print STDERR color("red"), "ERROR in computing count records for table 1_Sequence\n", color("reset");
		&err_message("ERROR in computing count records for table 1_Sequence\n");
	}
	#4 Table HITS
	$count = undef;
	$count = &count_records($db,"2_Hits");
	if (defined($count)) 
	{
		print STDERR "$count records in table 2_Hits\n";
		&warr_message("$count records in table 2_Hits\n");
	}
	else 
	{
		$c_err++;
		print STDERR color("red"), "ERROR in computing count records for table 2_Hits\n", color("reset");
		&err_message("ERROR in computing count records for table 2_Hits\n");
	}
	#5 Table TERM
	$count = undef;
	$count = &count_records($db,"4_term");
	if (defined($count)) 
	{
		print STDERR "$count records in table 4_term\n";
		&warr_message("$count records in table 4_term\n");
	}
	else 
	{
		$c_err++;
		print STDERR color("red"), "ERROR in computing count records for table 4_term\n", color("reset");
		&err_message("ERROR in computing count records for table 4_term\n");
	}
	#6 Table TERM2TERM
	$count = undef;
	$count = &count_records($db,"5_term2term");
	if (defined($count)) 
	{
		print STDERR "$count records in table 5_term2term\n";
		&warr_message("$count records in table 5_term2term\n");
	}
	else 
	{
		$c_err++;
		print STDERR color("red"), "ERROR in computing count records for table 5_term2term\n", color("reset");
		&err_message("ERROR in computing count records for table 5_term2term\n");
	}
	#7 Table IPR
	$count = undef;
	$count = &count_records($db,"3_InterProScan_data");
	if (defined($count)) 
	{
		print STDERR "$count records in table 3_InterProScan_data\n";
		&warr_message("$count records in table 3_InterProScan_data\n");
	}
	else 
	{
		$c_err++;
		print STDERR color("red"), "ERROR in computing count records for table 3_InterProScan_data\n", color("reset");
		&err_message("ERROR in computing count records for table 3_InterProScan_data\n");
	}
	#8 Table GO_parse
	$count = undef;
	$count = &count_records($db,"6_GO_parse");
	if (defined($count)) 
	{
		print STDERR "$count records in table 6_GO_parse\n";
		&warr_message("$count records in table 6_GO_parse\n");
	}
	else 
	{
		$c_err++;
		print STDERR color("red"), "ERROR in computing count records for table 6_GO_parse\n", color("reset");
		&err_message("ERROR in computing count records for table 6_GO_parse\n");
	}
	#9 Table GO_analysis
	$count = undef;
	$count = &count_records($db,"8_GO_analysis");
	if (defined($count)) 
	{
		print STDERR "$count records in table 8_GO_analysis\n";
		&warr_message("$count records in table 8_GO_analysis\n");
	}
	else 
	{
		$c_err++;
		print STDERR color("red"), "ERROR in computing count records for table 8_GO_analysis\n", color("reset");
		&err_message("ERROR in computing count records for table 8_GO_analysis\n");
	}
	#10 Count GO information SEQ
	$count = undef;
	$count = $db->do("SELECT DISTINCT 1_Sequence.1_seq_name FROM 1_Sequence, 6_GO_parse WHERE 1_Sequence.1_seq_name = 6_GO_parse.6_seq_name;");
	if (defined($count)) 
	{
		print STDERR "In these database is $count sequences with GO records.\n";
		&warr_message("In these database is $count sequences with GO records.\n");
 	}
	else 
	{
		$c_err++;
		print STDERR color("red"), "ERROR in computing sequences count with GO records.\n", color("reset");
		&err_message("ERROR in computing sequences count with GO records.\n");
	}
	#12 Evaluate if ERR
	if (!($c_err)) 
	{
		return 1;
	}
	else 
	{
		print STDERR color("red"), "ERROR: Procedure getting number of records was finish with $c_err errors.\n", color("reset");
		&err_message("ERROR: Procedure getting number of records was finish with $c_err errors.\n");
		return 0;
	}
}

###################################################################################################
############################### GO INFORMATION DOWNLOAD FUNCTIONS #################################
###################################################################################################

#IMPGO 1# - Download data from GO consortium database - function(%params)
#Return: 0 if problem with download, 1 if download is OK
sub dwl_structure 
{
	#1 Define local parametres and run threads
	local %params = @_;		# Field with input values
	my $i = 0;
	my $a = 0;
	my $dbd;			# Database				
	my $vlakno_t2t = threads->new(\&dwl_go_term2term);
	my $vlakno_term = threads->new(\&dwl_go_term);
	
	#2 Sleep before print message
	sleep 1;
	print STDERR color("blue"), "MESSAGE: Starting download informations from GO database...\n", color("reset");
	&warr_message("MESSAGE: Starting download informations from GO database...\n");
	
	#3 While loop for control threads
	while (!(($vlakno_t2t->is_joinable()) && ($vlakno_term->is_joinable()))) 
	{
		sleep 5;
	}
	
	#4 Finish joinable threads
	$i = $i + ($vlakno_t2t->join);
	$i = $i + ($vlakno_term->join);
	
	#5 If not fullfill INSERT OPTION
	if ($i < 2)
	{
		#5A Insert data
		$dbd = 'mysql -u ' . $params{'db_user'} . ' -p"'. $params{'db_heslo'} . '" -h ' . $params{'db_host'} . ' ' . $params{'db_name'} . ' < backup_file.sql';
		$i = `$dbd`;
		
		#5B Reset counter
		$i = 0;
		#5C Get access to DB
		$dbd = &pristup($params{'db_host'}, $params{'db_name'}, $params{'db_user'}, $params{'db_heslo'});
		if (!(defined($dbd)))
        	{
        		return 0;
        	}
		#5D Verify
		$a = 0;
		$a = $dbd->do("SELECT * FROM 4_term;");
		if ($a > 1000)
		{
			$i++;
		}
		$a = 0;
		$a = $dbd->do("SELECT * FROM 5_term2term;");
		if ($a > 1000)
		{
			$i++;
		}
		$dbd->disconnect;
		if ($i == 2)
		{
			#A If problem solved
                        print STDERR color("red"), "WARRNING: Problem with download data from GENE ONTOLOGY database. The data was replaced from data backup.\n", color("reset");
                        &err_message("WARRNING: Problem with download data from GENE ONTOLOGY database. The data was replaced from data backup.\n");
			return 1;
		}
		else
		{
			#B If problem in threads
        		print STDERR color("red"), "ERROR: Problem with download data from GENE ONTOLOGY database. Please check the manual or your internet connection.\n", color("reset");
        		&err_message("ERROR: Problem with download data from GENE ONTOLOGY database. Please check the manual or your internet connection.\n");
			return 1;
		}
	}	
	
	#6A Verify threads
	if ($i == 2) 
	{
		#A Print mesage about DWL
		print STDERR color("green"), "MESSAGE: Data from gene ontology database is succesfully inserted.\n", color("reset");
		&warr_message("MESSAGE: Data from gene ontology database is succesfully inserted.\n");
		#B Get access to DB
		$dbd = &pristup($params{'db_host'}, $params{'db_name'}, $params{'db_user'}, $params{'db_heslo'});
		if (!(defined($dbd)))
		{
			return 0;
		}
		#C Compute level for GO terms
		if (&level_charakterize($dbd)) 
		{
			print STDERR color("green"), "MESSAGE: Computing level characterize was success.\n", color("reset");
			&warr_message("MESSAGE: Computing level characterize was success.\n");
		}
		else
		{
			print STDERR color("red"), "ERROR: Problem with computing gene ontology level.\n", color("reset");
			&err_message("ERROR: Problem with computing gene ontology level.\n");
			$dbd->disconnect;
			return 0;
		}
		#D Print message for computing subtrees CC,BP and MF
		print STDERR color("blue"), "MESSAGE: Computing subtrees for CC, BP and MF is initialized.\n", color("reset");
		&warr_message("MESSAGE: Computing subtrees for CC, BP and MF is initialized.\n");
		#E Subtree computing
		if ((&subtree_computing($dbd,310,1)) && (&subtree_computing($dbd,2891,2)) && (&subtree_computing($dbd,6684,3))) 
		{
			print STDERR color("green"), "MESSAGE: Computing subtrees for MF,CC,BP was finished.\n", color("reset");
			&warr_message("MESSAGE: Computing subtrees for MF,CC,BP was finished.\n");
			$dbd->disconnect;
			return 1;
		}
		else
		{
			print STDERR color("red"), "ERROR: Problem with computing subtrees.\n", color("reset");
			&err_message("ERROR: Problem with computing subtrees.\n");
			$dbd->disconnect;
			return 0;
		}
	}
	#6B If problem in threads
	print STDERR color("red"), "ERROR: Problem with download data from GENE ONTOLOGY database. Please check the manual or your internet connection.\n", color("reset");
	&err_message("ERROR: Problem with download data from GENE ONTOLOGY database. Please check the manual or your internet connection.\n");
	return 0;
}

#IMPGO 2# - Download data for term2term from GO consortium database - function()
#Return: 0 if problem detecked, 1 if OK
sub dwl_go_term2term
{
	#1 Define local variables
	my $db_out = undef;		# Database
	my $db_GO; 				# Source database GO
	my $dw_prikaz;			# Order for insert into DB
	my $i = 0;				# Number of inserted records
	my $a = 0;				# Number of errors
	my $c_rec = 0;			# Number of records in DB
	my $data;				# Data from GO database
	
	#2 Get connection to DB
	$db_out = &pristup($params{'db_host'}, $params{'db_name'}, $params{'db_user'}, $params{'db_heslo'}); 	# Predani vystupni databaze
	if (!(defined($db_out)))
	{
		return 0;
	}
	
	#3 Connection to GO DS
	if ($db_GO = DBI->connect("DBI:mysql:database=go_latest;host=mysql-amigo.ebi.ac.uk;port=4085;", "go_select", "amigo")) 
	{
		#A Get data from database
		$data = $db_GO->prepare("SELECT * FROM term2term;");
		$data->execute;
		#B Insert data into database
		while(my($id, $rel_type, $term1, $term2, $comp) = $data->fetchrow_array) 
		{
			#a Increase counter of records
			$i++;
			#b INSERT OPERATION
			$dw_prikaz = $db_out->prepare("INSERT INTO 5_term2term (5_id, 5_relationship_type_id, 5_term1_id, 5_term2_id, 5_complete) VALUES (?,?,?,?,?)");
			if(!($dw_prikaz->execute($id, $rel_type, $term1, $term2, $comp))) 
			{
				# Print message if error
				print STDERR color("red"), "ERROR: Problem in insert information for record:\n $id \t $rel_type \t $term1 \t $term2 \t $comp \n", color("reset");
				&err_message("ERROR: Problem in insert information for record:\n $id \t $rel_type \t $term1 \t $term2 \t $comp \n");
				# increase counter of error
				$a++;
			}
		}

		#C Get count of records in DB
		$c_rec = $db_GO->do("SELECT * FROM term2term;");

		#D Validate errors
		if (($c_rec == $a + $i) && ($a == 0)) 
		{
			# Print message
			print STDERR color("blue"), "MESSAGE: No problems detected for insert term2term from count $i records.\n", color("reset");
			&warr_message("MESSAGE: No problems detected for insert term2term from count $i records.\n");
			# Disconnect DBS
			$db_GO->disconnect;
			$db_out->disconnect;
			return 1;
		}
		else 
		{
			# Print message if error
			print STDERR color("red"), "ERROR: Insertion data term2term was ended for $a problems with $i records.\n", color("reset");
			&err_message("ERROR: Insertion data term2term was ended with $a problems for $i records.\n");
			# Disconnect DBS
			$db_GO->disconnect;
			$db_out->disconnect;
			return 0;
		}
	}
}

#IMPGO 3# - Download data for table term from GO consortium database - function()
#Return: 0 if problem detected, 1 if OK
sub dwl_go_term 
{
	#1 Define local variables
	my $db_out;		# Database for insert
	my $db_GO; 		# Source database GO
	my $dw_prikaz;	# Order for insert
	my $i = 0;		# Number of errors
	my $a = 0;		# Number of inserted records
	my $c_rec = 0;	# Number of records in DB
	my $data;		# Data from GO database

	#2 Create connection with DBS
	$db_out = &pristup($params{'db_host'}, $params{'db_name'}, $params{'db_user'}, $params{'db_heslo'});
	if (!(defined $db_out)) 
	{
		return 0;
	}

	#3 Create connection to GO database
	if($db_GO = DBI->connect("DBI:mysql:database=go_latest;host=mysql.ebi.ac.uk;port=4085;", "go_select", "amigo")) 
	{
		#A Get data from GO database
		$data = $db_GO->prepare("SELECT * FROM term;");
		$data->execute;
		#B Loop for insertion records
		while(my($id, $name, $term_type, $acc, $is_obs, $is_root, $is_relat) = $data->fetchrow_array) 
		{
			#a Increase counter of records
			$i++;
			#b INSERT ORDER
			$dw_prikaz = $db_out->prepare("INSERT INTO 4_term (4_id, 4_name, 4_term_type, 4_acc, 4_is_obsolete, 4_is_root, 4_is_relation) VALUES(?,?,?,?,?,?,?)");
			if(!($dw_prikaz->execute($id, $name, $term_type, $acc, $is_obs, $is_root, $is_relat))) 
			{
				# Print message about error
				print STDERR color("red"), "ERROR: Problem in insert information for record:\n $id \t $name \t $term_type \t $acc \t $is_obs \t $is_root \t $is_relat \n", color("reset");
				&err_message("ERROR: Problem in insert information for record:\n $id \t $name \t $term_type \t $acc \t $is_obs \t $is_root \t $is_relat \n");
				# Increase counter of errors
				$a++;
			}
		}

		#C Get count of records for GO DBS
		$c_rec = $db_GO->do("SELECT * FROM term;");

		#D Validate count of records
		if (($c_rec == $a + $i) && ($a == 0)) 
		{
			# Print message if all is correct
			print STDERR color("blue"), "MESSAGE: No problems detected for insert term from count $i records.\n", color("reset");
			&warr_message("MESSAGE: No problems detected for insert term from count $i records.\n");
			# Disconnect DBS
			$db_GO->disconnect;
			$db_out->disconnect;
			return 1;
		}
		else 
		{
			# Print error message
			print STDERR color("red"), "ERROR: Insertion data term2term was ended with $a problems with $i records.\n", color("reset");
			&err_message("ERROR: Insertion data term2term was ended with $a problems with $i records.\n");
			# Disconnect DBS
			$db_GO->disconnect;
			$db_out->disconnect;
			return 0;
		}
	}
}

#IMPGO 4# - Computing levels for GO records - function(database)
#Return: 0 calculating level faill, 1 calculating correct
sub level_charakterize 
{
	#1 Define local variables
	my $db = shift;
	my $level = 1;
	my $pocet = 0;
	
	#2 Set data for level 1 (ROOT LEVEL)
	return 0 unless $db->do("UPDATE 4_term SET 4_level = 1 WHERE 4_is_root = 1");
	return 0 unless $db->do("CREATE TABLE temp_table (id integer not null);");
	
	#3 Create data structure
	while ((($db->do("SELECT * FROM 4_term WHERE 4_level = $level LIMIT 10;")) != 0) && $level < 40) 
	{
		#A Provide INSERT operation
		$db->do("INSERT INTO temp_table SELECT 5_term2term.5_term2_id FROM 5_term2term, 4_term 
				WHERE 4_term.4_level = $level AND 4_term.4_is_obsolete = 0 AND 5_term2term.5_term1_id = 4_term.4_id;");
		#B Increase counter of level
		$level++;
		#C Get count of records
		$pocet = $db->do("UPDATE 4_term,temp_table SET 4_term.4_level = $level WHERE 4_term.4_is_obsolete = 0 AND 4_term.4_id = temp_table.id AND 4_term.4_level = 0;");
		#D Print message about records
		print STDERR "For level $level was update $pocet records in table 4_term.\n";
		#E Kill proces if delete temp table is unsuccess
		$level = 40 unless &del_tab($db, "temp_table");
	}
	
	#4 Delete temp table
	return 0 unless $db->do("DROP TABLE IF EXISTS temp_table;");
	
	#5 Return ALL is OK
	return 1;
}

#IMPGO 5# - Computing species of GO numbers for subtrees BP,MF,CC
#Return: 0 calculating level faill, 1 calculating subtree correct
sub subtree_computing 
{
	#1 Define local variables
	my $db = shift;
	my $inp_root = shift;
	my $value = shift;

	#2 Insert value into root and other DB operation
	return 0 unless $db->do("UPDATE 4_term SET 4_group = $value WHERE 4_id = $inp_root;");
	return 0 unless $db->do("CREATE TABLE temp_table (id integer not null);");
	return 0 unless $db->do("INSERT INTO temp_table SELECT 5_term2term.5_term2_id FROM 5_term2term, 4_term 
							WHERE 4_term.4_is_obsolete = 0 and 5_term2term.5_term1_id = 4_term.4_id AND 4_term.4_id = $inp_root;");
							
	#3 Create data structure
	while (($db->do("SELECT temp_table.* FROM 4_term, temp_table WHERE 4_term.4_is_obsolete = 0 AND 4_term.4_id = temp_table.id AND 4_term.4_group = 0 LIMIT 5;")) != 0) 
	{
		#A UPDATE operation
		$db->do("UPDATE 4_term,temp_table SET 4_term.4_group = $value WHERE 4_term.4_is_obsolete = 0 AND 4_term.4_id = temp_table.id AND 4_term.4_group = 0;");
		#B Delete records from temp table
		return 0 unless &del_tab($db, "temp_table");
		#C Insert records into temp table
		return 0 unless $db->do("	INSERT INTO temp_table SELECT 5_term2term.5_term2_id 
									FROM 5_term2term, 4_term 
									WHERE 4_term.4_is_obsolete = 0 AND 5_term2term.5_term1_id = 4_term.4_id AND 4_term.4_group = $value;");
	}
	
	#4 Return error if remove temp table give error
	return 0 unless $db->do("DROP TABLE IF EXISTS temp_table;");
	
	#5 Return ALL is OK
	return 1;
}

###################################################################################################
####################################### INSERT FUNCTIONS DATABASE #################################
###################################################################################################

#INSDB 1# - Insertion GO records on database - function(database, name, AC_number, GO_number)
#Return: 0 calculating level faill, 1 correct insert
sub add_GO_entry 
{
	#1 Local variablec
	my $databaze = shift;
	my $name = shift;
	my $AC_num = shift;
	my $GO_num = shift;
	my $prikaz;
	my $text;
	my $GO_acc = undef;
	#2 Modify variables
	$AC_num =~ s/\n//g;
	$name =~ s/\n//g;
	#3 Verify GO number
	$GO_acc = &over_GO_num($GO_num);
	#4 If not defined return 0
	if (!defined($GO_acc)) 
	{
		return 0;
	}
	#5 If AC num undef insert record with others values
	if ($AC_num eq "") 
	{
		$prikaz = $databaze->prepare("INSERT INTO 6_GO_parse (6_seq_name, 6_GO_number) 
						VALUES (?,?) ON DUPLICATE KEY UPDATE 6_seq_name = 6_seq_name;");	
		if ($prikaz->execute($name, $GO_acc)) 
		{
			return 1;
		}
	}
	#6 If AC number is defined insert record with values
	else 
	{
		$text = "INSERT INTO 6_GO_parse (6_seq_name, 6_entry_ac, 6_GO_number) 
						VALUES (?,?,?) ON DUPLICATE KEY UPDATE 6_entry_ac = '" . $AC_num . "';";
		$prikaz = $databaze->prepare($text);
		if ($prikaz->execute($name, $AC_num, $GO_acc)) 
		{
			return 1;
		}
	}
	#7 If problem print output message and return 0
	print STDERR color("red"), "ERROR: Problem with insert GO number into database with name sequence $name and value $GO_num.\n", color("reset");
	&err_message("ERROR: Problem with insert GO number into database with name sequence $name and value $GO_num.\n");
	return 0;
}

#INSDB 2# - Verify GO number if is correct - function(GO_number)
#Return: correct GO number
sub over_GO_num 
{
	#1 Get local variables
	my $GO_num = shift;
	my $GO_acc = '';

	#2A Verify DATA and remove text
	if ($GO_num =~ "GO:") 
	{
		$GO_acc = "GO:";
		$GO_num =~ s/\D//g;
		$GO_acc .= $GO_num;
	}
	#2B Format number into the right format
	else 
	{	
		$GO_num =~ s/\D//g;		
		if ($GO_num < 10) 
		{
			$GO_acc = "GO:000000";
			$GO_acc .= $GO_num;
		}			
		elsif ($GO_num < 100) 
		{
			$GO_acc = "GO:00000";
			$GO_acc .= $GO_num;
		}
		elsif ($GO_num < 1000) 
		{
			$GO_acc = "GO:0000";
			$GO_acc .= $GO_num;
		}
		elsif ($GO_num < 10000) 
		{
			$GO_acc = "GO:000";
			$GO_acc .= $GO_num;
		}
		elsif ($GO_num < 100000) 
		{
			$GO_acc = "GO:00";
			$GO_acc .= $GO_num;
		}
		elsif ($GO_num < 1000000) 
		{
			$GO_acc = "GO:0";
			$GO_acc .= $GO_num;
		}
		else 
		{
		$GO_acc = "GO:";
		$GO_acc .= $GO_num;
		}
	}
	#3 Return formated value
	return $GO_acc;
}

#INSDB 3# - Insert GO records to DB - function(database, @parameters)
#Return: 1 if correct, 0 if incorrect, 2 GO_id is missing
sub add_GO_struct 
{
	#1 Define local parameters
	my $databaze = shift;
	my %params = @_;
	my $prikaz;
	
	#2 Verify params
	if ($params{'Query_id'} eq '' || $params{'GO_id'} eq '') 
	{
		# Print ERROR message and return
		print STDERR color("red"), "ERROR: GO entry cannot be insert into database for sequence ", $params{'Query_id'} ,".\n", color("reset");
		&err_message("ERROR: GO entry cannot be insert into database for sequence " . $params{'Query_id'} . ".\n");
		return 0;
	}
	
	#3 If GO is not in right format
	if (!($params{'GO_db'} eq 'GO')) 
	{
		print STDERR color("red"), "ERROR: GO record have bad database format for insert into database for sequence ", $params{'Query_id'} ,".\n", color("reset");
		&err_message("ERROR: GO record have bad database format for insert into database for sequence " . $params{'Query_id'} . ".\n");
		return 2;
	}
	
	#4 Extract and control params from field
	$params{'Query_id'} =~ s/\n//g;
	$params{'GO_id'} = &over_GO_num($params{'GO_id'});
	
	#5 Insert params into DB and return
	$prikaz = $databaze->prepare("INSERT INTO 6_GO_parse (6_seq_name, 6_GO_number) VALUES (?,?) ON DUPLICATE KEY UPDATE 6_seq_name = 6_seq_name;");	
	return 0 unless ($prikaz->execute($params{'Query_id'},$params{'GO_id'}));
	return 1;
}

#INSDB 5# - Insert record from IPRSCAN - function(database, @pole)
#Return: 1 if correct, 0 if incorrect
sub add_IPR_entry 
{
	#1 Define local variables
	my $databaze = shift;
	my %params = @_;
	my $prikaz;

	#2 Verify required parameters
	return 0 if ($params{'Query_id'} eq '');
	return 0 if ($params{'library'} eq '');

	#3 Modifying name parameter
	$params{'Query_id'} =~ s/\n//g;

	#4 INSERT RECORD INTO DB
	if (defined($params{'evalue'}) && defined($params{'score'})) 
	{
		#A Create order
		$prikaz = $databaze->prepare("	INSERT INTO 3_InterProScan_data (	3_seq_name, 3_database, 3_score, 3_evalue, 
										3_signature_name, 3_signature_desc, 3_signature_ac, 3_entry_type, 
										3_entry_name, 3_entry_desc, 3_entry_ac)
										VALUES (?,?,?,?,?,?,?,?,?,?,?) ON DUPLICATE KEY UPDATE 3_seq_name = 3_seq_name;");
		#B Execute order 
		if ($prikaz->execute($params{'Query_id'},$params{'library'},$params{'score'},$params{'evalue'},
					$params{'sig_name'},$params{'sig_desc'},$params{'sig_ac'},
					$params{'ent_type'},$params{'ent_name'},$params{'ent_desc'},$params{'ent_ac'})) 
		{
			return 1;
		}
		#C If ERROR print MESSAGE
		else 
		{
			print STDERR color("red"), "ERROR: Problem with insert record from ipr scan into database for sequence ", $params{'Query_id'}, ".\n", color("reset");
			&err_message("ERROR: Problem with insert record from ipr scan into database for sequence " . $params{'Query_id'} . ".\n");
			return 0;
		}
	}
	else 
	{
		#A Create order
		$prikaz = $databaze->prepare(" 	INSERT INTO 3_InterProScan_data (3_seq_name, 3_database, 
										3_signature_name, 3_signature_desc, 3_signature_ac, 3_entry_type, 
										3_entry_name, 3_entry_desc, 3_entry_ac)
										VALUES (?,?,?,?,?,?,?,?,?) ON DUPLICATE KEY UPDATE 3_seq_name = 3_seq_name;");
		#B Execute order
		if ($prikaz->execute(	$params{'Query_id'},$params{'library'},
								$params{'sig_name'},$params{'sig_desc'},$params{'sig_ac'},
								$params{'ent_type'},$params{'ent_name'},$params{'ent_desc'},$params{'ent_ac'})) 
		{
			return 1;
		}
		#C If ERROR print MESSAGE
		else 
		{
			print STDERR color("red"), "ERROR: Problem with insert record from ipr scan into database for sequence ", $params{'Query_id'}, ".\n", color("reset");
			&err_message("ERROR: Problem with insert record from ipr scan into database for sequence " . $params{'Query_id'} . ".\n");
			return 0;
		}
	}	
	return 0;
}

#INSDB 6# - Import record from text file in tab delimited format - function(database,name_file)
#Return: 1 if correct, 0 if incorrect
sub import_GO 
{
	#1 Get local variables
	my $db = shift;
	my $soubor = shift;
	my $radek = "";
	my @sloupce;
	my $i = 0;
	my $a = 0;
	my $x = 0;
	my $sloupec;				# Field for collums
	my $GO_id = 2;
	my $GO_name = 0;
	my $AC_number = 1;
	
	#2 Open input file
	if (!(open (ZDROJ, $soubor))) 
	{
		print STDERR color("red"), "ERROR: Input file does not exist.\n", color("reset");
        &err_message("ERROR: Input file does not exist.\n");
		return 0;
	}
	
	#3 Print intro message
	print STDERR color("blue"), "MESSAGE: Procedure insert GO numbers was launched.\n", color("reset");
	&warr_message("MESSAGE: Procedure insert GO numbers was launched.\n");
	
	#4 Parsing file
	while ($radek = <ZDROJ>) 
	{
		#A Get collums
		@sloupce = split("\t", $radek);
		$i = 0;
		#B Parsing collums
		foreach $sloupec (@sloupce) 
		{
			# Find GO number in collums for row and select GO_id
			if ($sloupec =~ "GO:") 
			{
				$GO_id = $i;
			}
			# Increase counter ID collumn
			$i++;		
		}
		#C Verify value with GO_id
		if (($sloupce[$GO_id] =~ "GO:") && ($sloupce[0] ne "")) 
		{
			# Increase counter of records
			$x++;
			# If AC_number if equal to GO_ID (Format: name - AC_number - GO_number)
			if ($GO_id == $AC_number) 
			{
				$a = $a + &add_GO_entry($db, $sloupce[0], "", $sloupce[$GO_id])
			}
			# If not insert GO_ID
			elsif ($AC_number ne "") 
			{
				$a = $a + &add_GO_entry($db, $sloupce[0], $sloupce[$AC_number], $sloupce[$GO_id]);
			}
		}
		#D Print message if 1000 lines is procceded
		if (!($x%1000)) 
		{
			print STDERR $x, " lines is processed.\n";
		}
	}
	
	#5 If Coune of records is equal count of succesfully inserted records
	if ($x == $a) 
	{ 
		print STDERR color("green"), "MESSAGE: Procedure insert GO numbers finished with 0 errors. $x records was inserted.\n", color("reset");
		&warr_message("MESSAGE: Procedure insert GO numbers finished with 0 errors. $x records was inserted.\n");
		return 1;
	}
	else 
	{
		print STDERR color("red"), "ERROR: Procedure insert GO numbers finished with ", $x - $a, "errors.\n", color("reset");
		&err_message("ERROR: Procedure insert GO numbers finished with ", $x - $a, "errors.\n");
		return 2;
	}
}

#INSDB 7# - Import DEG data from csv file - function(database,csv_file)
#Return: 1 if correct, 0 if incorrect
sub ins_dfg_csv 
{
	#1 Get variables
	my $db = shift;			# Database
	my $csv_f = shift;		# Name of csv file

	#2 Set local fields and variables
	my @fields;			# Field includes collums
	my $i = 0;			# Errors
	my $a = 0;			# Succes rows
	my $control = 0;		# Control value for collumns
	my $sloupec;			# Temp collumn
	my $csv;				# CSV file
	my $sql;				# Variable for SQL query
	my $line;			# Extract line from file
	my @lines;			# Field for ROWS
	my $fh;				# File holder
	
	#3 Variables for collumn identificators
	my $baseMean_id = 1;		# BASE MEAN identificator
	my $Log2F_id = 2;		# LOG2FOLD identificator
	my $pValue_id = 5;		# pVALUE identificator
	my $pAdj = 6;			# pADJ identificator
	
	#4 Delete data from table
	return 0 unless &del_tab($db, "7_DEG");

 	#5 Create CSV object
	$csv = Text::CSV->new ( { binary => 1 } )  # should set binary attribute.
    	or die "Cannot use CSV: ".Text::CSV->error_diag ();
	
	#6 Open CSV file
	open $fh, "<:encoding(utf8)", $csv_f or die "$csv_f: $!";	

	#7 First line includes heads -> SET INDEX
	while ($line = <$fh>) 
	{
		if ($csv->parse($line)) 
		{
			#A Get fields
			@fields = $csv->fields();
			#B Set counter to one
			$i = 0;
			#C Seeking heads		
			foreach $sloupec (@fields) 
			{				
				#a Column baseMean	
				if ($sloupec =~ /baseMean/) 
				{
					$baseMean_id = $i;
					$control++;
					
				}
				#b Column log2FoldChange
				if ($sloupec =~ /log2FoldChange/) 
				{
					$Log2F_id = $i;
					$control++;	
				}
				#c Column pvalue
				if (($sloupec =~ /pvalue/) || ($sloupec =~ /pValue/))
				{
					$pValue_id = $i;
					$control++;
				}
				#d Column padj
				if (($sloupec =~ /padj/) || ($sloupec =~ /pAdj/))
				{
					$pAdj = $i;
					$control++;
				}
				#e Increase counter
				$i++;
			}
			if($control == 4)
			{				
				last;
			}
		}
	}

	#8 Control option for INDEX OF COLLUMS
	if (!($control == 4))
	{
		close $fh;
		print STDERR color("red"), "ERROR: Format for input file is probably wrong. One or more headers are undefined.\n", color("reset");
		&err_message("ERROR: Format for input file is probably wrong. One or more headers are undefined.\n");
		return 0;
	}

	#9 Get data from other rows - set counters
	$i = 0;		# Error rows
	$a = 0;		# Succes rows

	#10 Get data from other rows - local variables
	$sql = $db->prepare("INSERT INTO 7_DEG (7_seq_name,7_baseMean,7_log2FoldChange,7_pvalue,7_padj) VALUES(?,?,?,?,?) ON DUPLICATE KEY UPDATE 7_padj = 7_padj;");
	@lines = <$fh>;

	#11 Get data from other rows - print message
	print STDERR color("green"), "MESSAGE: Procedure insert informations about DEGs into database has been started.\n", color("reset");
	&warr_message("MESSAGE: Procedure insert informations about DEGs into database has been started.\n");

	#12 Get data from other rows - parse other lines
	foreach $line (@lines) 
	{	
		chomp $line;
		#A Parsing line
		if ($csv->parse($line)) 
		{
			#a Cells into fields
			@fields = $csv->fields();

			#b If name is present and value are numeric
			if (	($fields[$baseMean_id - 1] ne '') && (($fields[$baseMean_id] =~ /[^0-9]/) || ($fields[$baseMean_id] eq '0'))  &&
				(($fields[$Log2F_id] =~ /[^0-9]/) || ($fields[$Log2F_id] eq '0')) &&
				(($fields[$pValue_id] =~ /[^0-9]/) || ($fields[$pValue_id] eq '0')) &&
				(($fields[$pAdj] =~ /[^0-9]/) || ($fields[$pAdj] eq '0')) && ($fields[$baseMean_id] ne 'NA') 
				&& ($fields[$Log2F_id] ne 'NA') && ($fields[$pValue_id] ne 'NA') && ($fields[$pAdj] ne 'NA')
			) 
			{
				# Insert data to the DB
				if($sql->execute($fields[$baseMean_id - 1], $fields[$baseMean_id], $fields[$Log2F_id], $fields[$pValue_id], $fields[$pAdj]))
				{
					$a++; #Increment succes row
				}
				# Print error message
				else 
				{
					# Increment error value
					$i++;
					# Print error MESSAGE
					print STDERR color("red"), "ERROR: Problem with insert record in csv file on line ", $a+$i, ".\n", color("reset");
					&err_message("ERROR: Problem with insert record in csv file on line " . $a+$i . ".\n");
				}
			}
			#else
			if (2 < 5) 
			{
				# If in row is error
				if (($fields[$pValue_id] eq "NA") || ($fields[$pAdj] eq "NA") || ($fields[$baseMean_id] ne 'NA') || ($fields[$Log2F_id] ne 'NA')) 
				{
					$i++; #Increment error value
				}
				else 
				{				
					print STDERR color("red"), "ERROR: Problem with insert record in csv file on line ", $a+$i, ".\n", color("reset");
					&err_message("ERROR: Problem with insert record in csv file on line " . $a+$i . ".\n");
					$i++; #Increment error value
				}
			}
		}
		#B Problem with parsing row
		else 
		{
			# Increment error counter
			$i++;
			# Print ERROR MESSAGE
			print STDERR color("red"), "ERROR: Problem with parsing line in csv file on line ", $a+$i, ".\n", color("reset");
			&err_message("ERROR: Problem with parsing line in csv file on line " . $a+$i . ".\n");
		}

		#C Print message if 1000 lines are processed
		if (!(($a+$i)%1000)) 
		{
			print STDERR $a+$i, " lines is processed.\n";
		}
 	}

	#13 Print error message or get eof
	$csv->eof or $csv->error_diag();

	#14 Sleep 5 seconds for finish insert into DB
	sleep 3;
	
	#15 Close csv file
 	close $fh;

	#16 Print close message with information about lines - succes
	print STDERR color("blue"), "MESSAGE: Operation insertion DEGs for $a records was succesfull.\n", color("reset");
	&warr_message("MESSAGE: Operation insertion DEGs for $a records was succesfull.\n");

	#17 Print close message with information about lines - errors
	if ($i) 
	{
		print STDERR color("red"), "ERROR: Operation insert DEGs was unsuccesfull for $i records.\n", color("reset");
		&err_message("ERROR: Operation insert DEGs was unsuccesfull for $i records.\n");
	}

	#18 Print MESSAGE if TABLE is EMPTY
	$i = 0;
	$i = $db->do("SELECT * FROM 7_DEG;");
	if ($i < 2)
	{
		print STDERR color("red"), "ERROR: In input table for analysis are no records. Please check format your input data.\n", color("reset");
        &err_message("ERROR: In input table for analysis are no records. Please check format your input data.\n");
		return 0;
	}	
	
	#19 If insertion succes give ret value
	return 1;
}

#INSDB 8# - Verify database for GO records in analytic mode - function(database)
#Return: 1 if correct, 0 if incorrect
sub verif_GOparse 
{
    	#1 Get variables
    	my $db = shift;

	#2 Local variables
	my $parse_count = 0;
	my $analyze_count = 0;

	#3 Get query
	$parse_count = $db->do("SELECT DISTINCT 6_seq_name FROM 6_GO_parse;");
	$analyze_count = $db->do("SELECT DISTINCT 8_seq_name FROM 8_GO_analysis;");

	#4 If numbers are equal
	if ($parse_count <= $analyze_count + 5)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

#INSDB 9# - Insertion record about DEG from TXT input file - function(database, name_of_input_file)
#Return: 1 if correct, 0 if incorrect
sub ins_dfg_txt 
{
	#1 Get local variables
	my $db = shift;
	my $soubor = shift;
	
	#2 Local variabled in function
	my $radek = "";
	my @sloupce;
	my $control = 0;
	my $i = 0;
	my $a = 0;
	my $sloupec;				# Field for collums
	my $sql;
	
	#3 Variables for collumn identificators
	my $baseMean_id = 1;		# BASE MEAN identificator
	my $Log2F_id = 2;		# LOG2FOLD identificator
	my $pValue_id = 5;		# pVALUE identificator
	my $pAdj = 6;			# pADJ identificator	
	
	#4 Open input file
	if (!(open (ZDROJ, $soubor))) 
	{
		print STDERR color("red"), "ERROR: Input file does not exist.\n", color("reset");
        	&err_message("ERROR: Input file does not exist.\n");
		return 0;
	}
	
	#5 Print intro message
	print STDERR color("blue"), "MESSAGE: Procedure insert records about DEG was launched.\n", color("reset");
	&warr_message("MESSAGE: Procedure insert records about DEG was launched.\n");
	
	#6 Delete data from table
	return 0 unless &del_tab($db, "7_DEG");
	
	#7 FIRST LINE - GET INDEXES
	while ($radek = <ZDROJ>) 
	{
		#A Get collums
		@sloupce = split("\t", $radek);

		#B Set counter
		$control = 0;
		$i = 0;
		#C Seeking heads		
		foreach $sloupec (@sloupce) 
		{	
			#a Modify structure
			$sloupec =~ s/\n//g;
			$sloupec =~ s/\s//g;			
			#a Column baseMean	
			if ($sloupec =~ /baseMean/) 
			{
				$baseMean_id = $i;
				$control++;	
			}
			#b Column log2FoldChange
			if ($sloupec =~ /log2FoldChange/) 
			{
				$Log2F_id = $i;
				$control++;	

			}
			#c Column pvalue
			if (($sloupec =~ /pvalue/) || ($sloupec =~ /pValue/))
			{
				$pValue_id = $i;
				$control++;

			}
			#d Column padj
			if (($sloupec =~ /padj/) || ($sloupec =~ /pAdj/))
			{
				$pAdj = $i;
				$control++;

			}
			#e Increase counter
			$i++;
		}
		if($control == 4)
		{				
			last;
		}
	}
	
	#8 Control option for INDEX OF COLLUMS
	if (!($control == 4))
	{
		print STDERR color("red"), "ERROR: Format for input file is probably wrong. One or more headers are undefined.\n", color("reset");
		&err_message("ERROR: Format for input file is probably wrong. One or more headers are undefined.\n");
		close $fh;
		return 0;
	}		

	#9 Get data from other rows - set counters
	$i = 0;		# Error rows
	$a = 0;		# Succes rows

	#10 Get data from other rows - local variables
	$sql = $db->prepare("INSERT INTO 7_DEG (7_seq_name,7_baseMean,7_log2FoldChange,7_pvalue,7_padj) VALUES(?,?,?,?,?) ON DUPLICATE KEY UPDATE 7_padj = 7_padj;");
	
	#11 Get data from other rows - parse other lines
	while ($radek = <ZDROJ>)
	{	
		#A Get collums
		@sloupce = split("\t", $radek);
		
		#B If name is present and value are numeric
		if 	(	($sloupce[$baseMean_id - 1] ne '') && 
			(($sloupce[$baseMean_id] =~ /[^0-9]/) || ($sloupce[$baseMean_id] eq '0'))  &&
			(($sloupce[$Log2F_id] =~ /[^0-9]/) || ($sloupce[$Log2F_id] eq '0')) &&
			(($sloupce[$pValue_id] =~ /[^0-9]/) || ($sloupce[$pValue_id] eq '0')) &&
			(($sloupce[$pAdj] =~ /[^0-9]/) || ($sloupce[$pAdj] eq '0')) && 
			($sloupce[$baseMean_id] ne 'NA') && ($sloupce[$Log2F_id] ne 'NA') && 
			($sloupce[$pValue_id] ne 'NA') && ($slopce[$pAdj] ne 'NA')
			) 
		{
			# Insert data to the DB
			if($sql->execute($sloupce[$baseMean_id - 1], $sloupce[$baseMean_id], $sloupce[$Log2F_id], $sloupce[$pValue_id], $sloupce[$pAdj]))
			{
				$a++; #Increment succes row
			}
			# Print error message
			else 
			{
				# Increment error value
				$i++;
				# Print error MESSAGE
				print STDERR color("red"), "ERROR: Problem with insert record in csv file on line ", $a+$i, ".\n", color("reset");
				&err_message("ERROR: Problem with insert record in csv file on line " . $a+$i . ".\n");
			}
		}
		# Else - error
		else
		{
				# If in row is error
				if (($sloupce[$pValue_id] eq "NA") || ($sloupce[$pAdj] eq "NA") || ($sloupce[$baseMean_id] ne 'NA') || ($sloupce[$Log2F_id] ne 'NA')) 
				{
					$i++; #Increment error value
				}
				else 
				{				
					print STDERR color("red"), "ERROR: Problem with insert record in csv file on line ", $a+$i, ".\n", color("reset");
					&err_message("ERROR: Problem with insert record in csv file on line " . $a+$i . ".\n");
					$i++; #Increment error value
				}
		}

		#C Print message if 1000 lines are processed
		if (!(($a+$i)%1000)) 
		{
			print STDERR $a+$i, " lines is processed.\n";
		}
 	}

	#12 Sleep 5 seconds for finish insert into DB
	sleep 3;
	
	#13 Close csv file
 	close $ZDROJ;

	#14 Print close message with information about lines - succes
	print STDERR color("blue"), "MESSAGE: Operation insertion DEGs for $a records was succesfull.\n", color("reset");
	&warr_message("MESSAGE: Operation insertion DEGs for $a records was succesfull.\n");

	#15 Print close message with information about lines - errors
	if ($i) 
	{
		print STDERR color("red"), "ERROR: Operation insert DEGs was unsuccesfull for $i records.\n", color("reset");
		&err_message("ERROR: Operation insert DEGs was unsuccesfull for $i records.\n");
	}

	#16 Print MESSAGE if TABLE is EMPTY
	$i = 0;
	$i = $db->do("SELECT * FROM 7_DEG;");
	if ($i < 2)
	{
		print STDERR color("red"), "ERROR: In input table for analysis are no records. Please check format your input data.\n", color("reset");
        &err_message("ERROR: In input table for analysis are no records. Please check format your input data.\n");
		return 0;
	}	
	
	#17 If insertion succes give ret value
	return 1;	
	
}

###################################################################################################
######################################## ANALYTICKE FUNKCE ########################################
###################################################################################################

#ANF 1# - Calculating GO tree for computing GO enrichment - function(database)
#Return: 1 if correct, 0 if incorrect
sub calculating_GOtree 
{
	#1 Local variables
	my $db = shift;
	my $i = 0;
	my $ins = 0;
	
	#2 Print introduction message
	print STDERR color("green"), "MESSAGE: Starting computing GO tree for whole dataset.\n", color("reset");
	&warr_message("MESSAGE: Starting computing GO tree for whole dataset.\n");
	
	#3 Drop temp table and delete data in GO_analysis
	$db->do("DROP TABLE IF EXISTS TMP_GO;");
	return 0 unless &del_tab($db, "8_GO_analysis");
	
	#4 Insert GO data into GO_ANALYSIS
	$ins = $db->do("INSERT INTO 8_GO_analysis (8_seq_name, 8_term_id) 
				SELECT 6_GO_parse.6_seq_name, 4_term.4_id FROM 6_GO_parse, 4_term 
				WHERE 6_GO_parse.6_GO_number = 4_term.4_acc;");
	
	#5 Print message about records
	print STDERR "For calculating GO level has been select $ins records.\n";
	&warr_message("For calculating GO level has been select $ins records.\n");

	#6 If we dont have any records
	if (!($ins)) 
	{
		print STDERR color("bold red"), "ERROR: No records for calculating gene ontology level.\n", color("reset");
		&err_message("ERROR: No records for calculating gene ontology level.\n");
		return 0; 
	}
	
	#7 Create table TMP_GO
	$db->do("CREATE TABLE TMP_GO (
				name char(100) not null,
				id_term integer not null,
				level integer default -1);");

	#8 Set ins value
	$ins = 0;
	
	#9 While loop for calculating GO tree
	while (($db->do("SELECT * FROM 8_GO_analysis WHERE 8_term_level = $i LIMIT 10;")) != 0) 
	{
		#A Give message for loop	
		print STDERR "Procedure calculating gene ontology for level $i is started.\n"; 
		&warr_message("Procedure calculating gene ontology for level $i is started.\n"); 
		#B Computing and insert into GO_ANALYSIS
		$db->do("INSERT INTO TMP_GO SELECT 8_GO_analysis.8_seq_name, 5_term2term.5_term1_id, 8_GO_analysis.8_term_level + 1
				FROM 8_GO_analysis, 5_term2term
				WHERE 8_GO_analysis.8_term_id = 5_term2term.5_term2_id AND 8_GO_analysis.8_term_level = $i;");
		$ins = $db->do("INSERT INTO 8_GO_analysis
				SELECT * FROM TMP_GO ON DUPLICATE KEY UPDATE
				8_GO_analysis.8_term_level = 8_GO_analysis.8_term_level + 1;");
		#C Info about computing
		if ($ins >= 1) 
		{
			print STDERR "Gene ontology level has been computed for $ins records.\n";
			&warr_message("Gene ontology level has been computed for $ins records.\n");
		}
		#D Increase counter and delete data from TB
		return 0 unless &del_tab($db, "TMP_GO");
		$i++;
	}
	
	#10 DROP temp table
	$db->do("DROP TABLE IF EXISTS TMP_GO;");
	
	#11 Message about calculating GO tree
	print STDERR color("green"), "MESSAGE: Calculating of gene ontology tree was succesfully finished.\n", color("reset");
    	&datab::warr_message("MESSAGE: Calculating of gene ontology tree was succesfully finished.\n");
	
	#12 Number of sequences in database detection
	$ins = 0;
    	$ins = $db->do("SELECT 1_seq_name FROM 1_Sequence;");
    	print STDERR color("blue"), "MESSAGE: In database is currently stored $ins records in table 1_Sequence.\n", color("reset");
    	&datab::warr_message("MESSAGE: In database is currently stored $ins records in table 1_Sequence.\n");

	#13 Number of sequences without annotation
	$ins = $ins - ($db->do("SELECT DISTINCT 6_GO_parse.6_seq_name FROM 6_GO_parse;"));
	if ($ins > 0)
	{
		print STDERR color("blue"), "MESSAGE: In database is still $ins records without any GO number.\n", color("reset");
    		&datab::warr_message("MESSAGE: In database is still $ins records without any GO number.\n");
	}

	#14 Return SUCCESS value
	return 1;
}

#ANF 2# - Get analytic procedure and export results - function(database, cut_padj, cut_log, cut_histogram, prefix_name, out_type_data)
#Return: 1 if correct, 0 if incorrect
sub analysis 
{
	#1 Get variables from input
	my $db = shift;					# Input database
	my $cut_padj = sprintf("%.10g", shift);		# CutOff for pAdj 
	my $cut_log = sprintf("%.10g", shift);		# CutOff for log2FoldChange
	my $cut_hist = sprintf("%.10g", shift);		# CutOff for HISTOGRAM
	my $prefix_name = shift;			# Prefix for OUTPUT FILE
	my $data_type = shift;				# OUT FORMAT

	#2 Declaration of local variables
	my $data_up;
	my $data_down;
	
	#3 Variables for statistics
	my $suma_fischer = 0;		# a+b+c+d
	my $n_DEG_fischer = 0;		# a+c

	#4 Verification CutOff for log2FoldChange
	if ($cut_log < 0) 
	{
		$cut_log = $cut_log * (-1);
	}

	#5 Print message about analysis - INTRO
	print STDERR color("green"), "MESSAGE: Proces of analysis DEGs was started.\n", color("reset");
    	&warr_message("MESSAGE: Proces of analysis DEGs was started.\n");

	# ANALYSIS UPREGULATED GENES
	#6 Delete previous results
	return 0 unless &del_tab($db, "9_GO_results");

	#7 INSERT data into work table - DFG_loc is 1
	if(!($db->do("INSERT INTO 9_GO_results (9_seq_name, 9_term_id, 9_log2FoldChange, 9_DEG_loc)
			SELECT 8_GO_analysis.8_seq_name, 8_GO_analysis.8_term_id, 7_DEG.7_log2FoldChange, 1 
			FROM 8_GO_analysis, 7_DEG
			WHERE 8_GO_analysis.8_seq_name = 7_DEG.7_seq_name AND 7_DEG.7_padj <= $cut_padj AND 7_DEG.7_log2FoldChange >= $cut_log;")))
	{
		print STDERR color("red"), "ERROR: Input data for this criteria are empty. Please check parameters.\n", color("reset");
		&err_message("ERROR: Input data for this criteria are empty. Please check parameters.\n");
		return 0;
	}
	
	#8 Get number DEG with GO_terms (a+c) - UP
	$n_DEG_fischer = $db->do("SELECT DISTINCT 7_DEG.7_seq_name FROM 7_DEG
							WHERE 7_DEG.7_log2FoldChange > $cut_log;");
	
	#9 Get numbber ALL genes with GO and log2Fold > 0 - UP
	$suma_fischer = $db->do("SELECT 1_seq_name FROM 1_Sequence;"); 

	#10 Insert rest records into GO_results table - transcriptome_loc is 1
	$db->do("INSERT INTO 9_GO_results (9_seq_name, 9_term_id) 
			SELECT 8_seq_name, 8_term_id 
			FROM 8_GO_analysis
			ON DUPLICATE KEY UPDATE 9_transcriptome_loc = 1;");

	#11 GET RESULTS FOR UP REGULATED GENES
	$data_up = $db->prepare("SELECT 4_term.4_level, 4_term.4_group, 4_term.4_acc, 4_term.4_name, sum(9_GO_results.9_transcriptome_loc), sum(9_GO_results.9_DEG_loc), 
				sum(9_GO_results.9_DEG_loc)/sum(9_GO_results.9_transcriptome_loc), sum(9_GO_results.9_log2FoldChange)/sum(9_GO_results.9_DEG_loc), 9_GO_results.9_term_id
				FROM 9_GO_results, 4_term 
				WHERE 9_GO_results.9_term_id = 4_term.4_id AND 4_term.4_is_obsolete = 0
				GROUP BY 9_GO_results.9_term_id 
				ORDER BY 4_term.4_level;");
	$data_up->execute;
	
	#12A PRINT DATA IN TXT FORMAT
	if ($data_type eq "txt") 
	{
		return 0 unless &export_result_txt($db, "UP", $prefix_name, $cut_hist, $cut_log, $suma_fischer, $n_DEG_fischer, $data_up, 0);
	}
	#12B Print data in CSV format
	elsif ($data_type eq "csv") 
	{
		return 0 unless &export_result_txt($db, "UP", $prefix_name, $cut_hist, $cut_log, $suma_fischer, $n_DEG_fischer, $data_up, 1);
	}
	#12C If format is unknown select default
	else 
	{
		#A Print Warning message
		print STDERR color("red"), "WARRING: Unknown format. Select default format for upregulated genes.\n", color("reset");
		&err_message("WARRING: Unknown format. Select default format for upregulated genes.\n");
		
		#B Print data in default format
		return 0 unless &export_result_txt($db, "UP", $prefix_name, $cut_hist, $cut_log, $suma_fischer, $n_DEG_fischer, $data_up, 0);
	}

	# ANALYSIS ALL-REGULATED GENES
	#6 Delete previous results
	return 0 unless &del_tab($db, "9_GO_results");

	#7 INSERT data into work table - DFG_loc is 1
	if(!($db->do("INSERT INTO 9_GO_results (9_seq_name, 9_term_id, 9_log2FoldChange, 9_DEG_loc)
			SELECT 8_GO_analysis.8_seq_name, 8_GO_analysis.8_term_id, 7_DEG.7_log2FoldChange, 1 
			FROM 8_GO_analysis, 7_DEG
			WHERE 8_GO_analysis.8_seq_name = 7_DEG.7_seq_name AND 7_DEG.7_padj <= $cut_padj AND (7_DEG.7_log2FoldChange >= $cut_log OR 7_DEG.7_log2FoldChange <= ($cut_log * (-1)));")))
	{
		print STDERR color("red"), "ERROR: Input data for this criteria are empty. Please check parameters.\n", color("reset");
		&err_message("ERROR: Input data for this criteria are empty. Please check parameters.\n");
		return 0;
	}
	
	#8 Get number DEG with GO_terms (a+c) - UP
	$n_DEG_fischer = $db->do("SELECT DISTINCT 7_DEG.7_seq_name FROM 7_DEG
							WHERE (7_DEG.7_log2FoldChange > $cut_log OR 7_DEG.7_log2FoldChange < ($cut_log * (-1)));");
	
	#9 Get numbber ALL genes with GO and log2Fold > 0 - UP
	#$suma_fischer = $db->do("SELECT DISTINCT 8_seq_name 
	#						FROM 8_GO_analysis;"); 

	#10 Insert rest records into GO_results table - transcriptome_loc is 1
	$db->do("INSERT INTO 9_GO_results (9_seq_name, 9_term_id) 
			SELECT 8_seq_name, 8_term_id 
			FROM 8_GO_analysis
			ON DUPLICATE KEY UPDATE 9_transcriptome_loc = 1;");

	#11 GET RESULTS FOR UP REGULATED GENES
	$data_up = $db->prepare("SELECT 4_term.4_level, 4_term.4_group, 4_term.4_acc, 4_term.4_name, sum(9_GO_results.9_transcriptome_loc), sum(9_GO_results.9_DEG_loc), 
				sum(9_GO_results.9_DEG_loc)/sum(9_GO_results.9_transcriptome_loc), sum(9_GO_results.9_log2FoldChange)/sum(9_GO_results.9_DEG_loc), 9_GO_results.9_term_id
				FROM 9_GO_results, 4_term 
				WHERE 9_GO_results.9_term_id = 4_term.4_id AND 4_term.4_is_obsolete = 0
				GROUP BY 9_GO_results.9_term_id 
				ORDER BY 4_term.4_level;");
	$data_up->execute;
	
	#12A PRINT DATA IN TXT FORMAT
	if ($data_type eq "txt") 
	{
		return 0 unless &all_export_result_txt($db, "ALL", $prefix_name, $cut_hist, $cut_log, $suma_fischer, $n_DEG_fischer, $data_up, 0);
	}
	#12B Print data in CSV format
	elsif ($data_type eq "csv") 
	{
		return 0 unless &all_export_result_txt($db, "ALL", $prefix_name, $cut_hist, $cut_log, $suma_fischer, $n_DEG_fischer, $data_up, 1);
	}
	#12C If format is unknown select default
	else 
	{
		#A Print Warning message
		print STDERR color("red"), "WARRING: Unknown format. Select default format for upregulated genes.\n", color("reset");
		&err_message("WARRING: Unknown format. Select default format for upregulated genes.\n");
		
		#B Print data in default format
		return 0 unless &all_export_result_txt($db, "ALL", $prefix_name, $cut_hist, $cut_log, $suma_fischer, $n_DEG_fischer, $data_up, 0);
	}

	# ANALYSIS DOWNREGULATED GENES
	#13 Delete previous results
	return 0 unless &del_tab($db, "9_GO_results");

	#14 Transformation cutoff value log2Fold
	$cut_log = $cut_log * (-1);

	#15 INSERT data into work table - pAdj < pAdj_cutOff and log2FoldChange <= Cutoff value
	if(!($db->do("INSERT INTO 9_GO_results (9_seq_name, 9_term_id, 9_log2FoldChange, 9_DEG_loc)
				SELECT 8_GO_analysis.8_seq_name, 8_GO_analysis.8_term_id, 7_DEG.7_log2FoldChange, 1 
				FROM 8_GO_analysis, 7_DEG
				WHERE 8_GO_analysis.8_seq_name = 7_DEG.7_seq_name AND 7_DEG.7_padj <= $cut_padj AND 7_DEG.7_log2FoldChange <= $cut_log;")))
	{
		print STDERR color("red"), "ERROR: Input data for this criteria are empty. Please check parameters.\n", color("reset");
		&err_message("ERROR: Input data for this criteria are empty. Please check parameters.\n");
		return 0;
	}
	
	#16 Get number DEG with GO_terms (a+c)
	$n_DEG_fischer = $db->do("SELECT DISTINCT 7_DEG.7_seq_name FROM 7_DEG
							WHERE 7_DEG.7_log2FoldChange <= $cut_log;"); 

	#17 INSERT rest records for whole transcriptome
	$db->do("INSERT INTO 9_GO_results (9_seq_name, 9_term_id) 
			SELECT 8_seq_name, 8_term_id 
			FROM 8_GO_analysis
			ON DUPLICATE KEY UPDATE 9_transcriptome_loc = 1;");

	#18 Get results for DOWN genes
	$data_down = $db->prepare("SELECT 4_term.4_level, 4_term.4_group, 4_term.4_acc, 4_term.4_name, sum(9_GO_results.9_transcriptome_loc), sum(9_GO_results.9_DEG_loc), 
				sum(9_GO_results.9_DEG_loc)/sum(9_GO_results.9_transcriptome_loc), sum(9_GO_results.9_log2FoldChange)/sum(9_GO_results.9_DEG_loc), 9_GO_results.9_term_id 
				FROM 9_GO_results, 4_term 
				WHERE 9_GO_results.9_term_id = 4_term.4_id AND 4_term.4_is_obsolete = 0
				GROUP BY 9_GO_results.9_term_id 
				ORDER BY 4_term.4_level;");
	$data_down->execute;

	#19A PRINT DATA IN TXT FORMAT
	if ($data_type eq "txt") 
	{
		return 0 unless &export_result_txt($db, "DOWN", $prefix_name, $cut_hist, $cut_log, $suma_fischer, $n_DEG_fischer, $data_down, 0);
	}
	#19B Export results if output is csv file
	elsif ($data_type eq "csv") 
	{
		return 0 unless &export_result_txt($db, "DOWN", $prefix_name, $cut_hist, $cut_log, $suma_fischer, $n_DEG_fischer, $data_down, 1);
	}
	#19C If unknown format select default
	else 
	{
		#A Print warring message
		print STDERR color("red"), "WARRING: Unknown format. Select default format for downregulated genes.\n", color("reset");
		&err_message("WARRING: Unknown format. Select default format for downregulated genes.\n");
		#B Give results for txt format
		return 0 unless &export_result_txt($db, "DOWN", $prefix_name, $cut_hist, $cut_log, $suma_fischer, $n_DEG_fischer, $data_down, 0);
	}
	return 1;
}

#ANF 3# - Function for EXPORT RESULTS IN TXT OR CSV - function(database, TYPE, prefix, step_hist, cutOff_log2F, sum_FT, n_DEG_FT, data_from_DB, CSV_control)
#Return: 1 if correct, 0 if incorrect
sub export_result_txt 
{
	#1 Get variables
	my $db = shift;				# Database for work
	my $type = shift;			# TYPE - UP/DOWN
	my $nazev = shift;			# Prefix
	my $range_cut = shift;		# Range for histogram
	my $log2F_cut = shift;		# CutOff for log2FoldChange
	my $suma_FT = shift;			# a+b+c+d for Fischers Exact Test
	my $n_DEG_FT = shift;		# a+c for Fischers Exact Test
	my $data = shift;			# Result data from DB
	my $CSV_control = shift;		# CSV control (IF 1 -> CSV OUTPUT)

	#2 Set local fields
	my (@pole_group) = ("UN","CC","MF","BP");
	my @pole;
	my @CSV_pole;

	#3 Set local variables
	my $DEGO_fischer = 0;		# a for FISCHER EXACT TEST
	my $GGO_fischer = 0;			# a+b for FISCHER EXACT TEST
	my $extrem = 0;				# Extrem value for GO term
	my $hist_min;				# First value for computing histogram
	my $max_range = 0;			# Max number genes in range
	my $max_range_counter = 0;	# Counter for max range
	my $F_test;					# Result from fischer exact test
	my $range_counter = 0;		# Members in range
	my $FILE;					# File for primary output
	my $HIST;					# File for histogram
	my $hist_data;				# Data from DB for histogram
	my $hist_var;				# Variable for work with histogram
	my $csv;						# CSV object
	my $head_CSV;				# CSV head for OUT file
	my $CSV_nazev;				# CSV name of file
	my $hist_nazev;				# Name of file for histogram

	#4 Modify nazev
	if ($nazev eq '-')
	{
		$nazev = '-';
	}
	if ($type eq 'UP')
	{
		$CSV_nazev = $nazev . "_GO_analysis_upregulated.csv";
		$hist_nazev = $nazev . "_Histogram_upregulated.txt";
		$nazev = $nazev . "_GO_analysis_upregulated.txt";
	}
	elsif ($type eq 'DOWN')
	{
		$CSV_nazev = $nazev . "_GO_analysis_downregulated.csv";
		$hist_nazev = $nazev . "_Histogram_downregulated.txt";
		$nazev = $nazev . "_GO_analysis_downregulated.txt";
	}

	#5 Create file for HISTOGRAM
	open( $HIST, '>', ($hist_nazev))
    	or die "Error: unable to open output file $hist_nazev ($!)";
	print $HIST "GO_id \t Min \t Max \t Number of genes\n";

	#6A PRINT STANDARD OUTPUT HEAD
	if (($nazev eq '-') && ($type eq 'UP'))
	{
		print STDOUT "Records for up-regulated genes:\n";
		print STDOUT "GO_Level \t Ontology source \t GO_id \t Description of GO \t Number of GO annotated sequences \t DEGs number \t Percent \t Mean log2FoldChange \t Extreme value \t Max histogram range \t Max histogram number \t p-value \n";
	}
	elsif (($nazev eq '-') && ($type eq 'DOWN'))
	{
		print STDOUT "Records for down-regulated genes:\n";
		print STDOUT "GO_Level \t Ontology source \t GO_id \t Description of GO \t Number of GO annotated sequences \t DEGs number \t Percent \t Mean log2FoldChange \t Extreme value \t Max histogram range \t Max histogram number \t p-value \n";
	}	
	#6B CREATE OUTPUT FILE IF SPECIFIED - CSV
	elsif ($CSV_control == 1)
	{
		################################################ CSV PLACE ##############################
		#A Create CSV object
		$csv = Text::CSV->new ( { binary => 1, eol => "\n" } )  # should set binary attribute.
		or die "Cannot use CSV: ".Text::CSV->error_diag (); 
        	#B Create CSV FILE
		open $FILE, ">:encoding(utf8)", $CSV_nazev 
		or die "Test.csv: $!";
		#C Print head into file
		$head_CSV = ([	"GO_Level","Ontology source","GO_id","Description of GO","Number of GO annotated sequences","DEGs number","Percent","Mean log2FoldChange","Extreme value","Max histogram range","Max histogram number","p-value"]);
		$csv->print($FILE, $head_CSV);
	}
	#6C CREATE OUTPUT FILE IF SPECIFIED - TXT	
	else
	{
		# Create file
		open( $FILE, '>', $nazev)
        	or die "Error: unable to open output file $nazev ($!)";
		# Print head into file
		print $FILE "GO_Level \t Ontology source \t GO_id \t Description of GO \t Number of GO annotated sequences \t DEGs number \t Percent \t Mean log2FoldChange \t Extreme value \t Max histogram range \t Max histogram number \t p-value \n";;
	}

	#7 PARSING DATA FROM DATAB QUERY
	while (@pole = $data->fetchrow_array)
	{
		#A If data not fullfill option -> NEXT ROW {percent > 0 and number DEG > 0)
		if (!($pole[6] > 0 && $pole[5]))
		{
			next;
		}
		
		#B Set values for HISTOGRAM AND OUTPUT
		$extrem = 0;				# Extrem value for GO number
		$range_counter = 0;		# Pocitadlo v danem rozsahu
		$hist_min = 0;			# Prvni hodnota v histogramu
		$max_range = 0;			# Max range category
		$max_range_counter = 0;	# Max range counter for category
		$GGO_fischer = 0;		# a+b for FISCHER EXACT TEST
		$F_test = undef;			# Result of the FISCHER EXACT TEST
		my $s = 0;
		
		#C Get HISTOGRAM DATA
		if ($pole[7] > 0) # UP
		{
			# For UP-REGULATED - get histogram data
			$hist_data = $db->prepare('SELECT 9_log2FoldChange FROM 9_GO_results WHERE 9_term_id = ' . $pole[8] . ' AND 9_log2FoldChange >= ' . $log2F_cut . ' ORDER BY 9_log2FoldChange;');
			$hist_data->execute;	
		}
		else # DOWN
		{
			# For DOWN-REGULATED - get histogram data
			$hist_data = $db->prepare('SELECT 9_log2FoldChange FROM 9_GO_results WHERE 9_term_id = ' . $pole[8] . ' AND 9_log2FoldChange <= ' . $log2F_cut . ' ORDER BY 9_log2FoldChange;');
			$hist_data->execute;		
		}			
		
		# Set HIST MIN
		$hist_var = ($hist_data->fetchrow_array);
		use integer;
		$hist_min = ($hist_var / 1) - 1;
		no integer;
		
		# Get EXTREM - DOWN
		if ($hist_var < 0)
		{
			$extrem = $hist_var;
		}
		
		#D Get and print values for HISTOGRAM
		do 
		{
			# If in range - count
			if ($hist_var < ($hist_min + $range_cut))
			{
				$range_counter++;
			}
			# If out of range PRINT
			else
			{
				# If number is 0 get to the other range
				if ($range_counter == 0)
				{
					while ($range_counter == 0)
					{
						# Print line INTO FILE
						print $HIST $pole[2], "\t", $hist_min, "\t", $hist_min + $range_cut, "\t", 0, "\n";
						# Increase range cut
						$hist_min = $hist_min + $range_cut;
						# Verify increase
						if ($hist_var < ($hist_min + $range_cut))
						{
							$range_counter++;
						}
					}
				}
				else
				{
					# PRINT RANGE INTO FILE
					print $HIST $pole[2], "\t", $hist_min, "\t", $hist_min + $range_cut, "\t", $range_counter, "\n";
					# Set best range if better
					if ($range_counter > $max_range_counter)
					{
						$max_range_counter = $range_counter;
						$max_range = $hist_min;
					}
					# Restart counter and range
					$hist_min = $hist_min + $range_cut;
					$range_counter = 0;
					# Verify new value
					if ($hist_var < ($hist_min + $range_cut))
					{
						$range_counter++;
					}
					else
					{
						while ($range_counter == 0)
						{
							# Print line INTO FILE
							print $HIST $pole[2], "\t", $hist_min, "\t", $hist_min + $range_cut, "\t", 0, "\n";
							# Increase range cut
							$hist_min = $hist_min + $range_cut;
							# Verify increase
							if ($hist_var < ($hist_min + $range_cut))
							{
								$range_counter++;
							}
						}
					}
				}
			}
			if ($hist_var > 0)
			{
				$extrem = $hist_var;
			}
		} while (($hist_var) = $hist_data->fetchrow_array);
		
		#E Print last row for HISTOGRAM
		print $HIST $pole[2], "\t", $hist_min, "\t", $hist_min + $range_cut, "\t", $range_counter, "\n";
		if ($range_counter > $max_range_counter)
		{
			$max_range_counter = $range_counter;
			$max_range = $hist_min;
		}
		
		#F If UP set EXTREM
		#if ($hist_var > 0)
		#{
		#	$extrem = $hist_var;
		#}
		
		#G Get result FISCHER TEST
		$F_test = (&fischer_test_GO($pole[5],$pole[4],$n_DEG_FT,$suma_FT));
	
		#H PRINT DATA TO STDOUT OR INTO FILE {CSV or TXT}
		if ($nazev eq '-')
		{
			print STDOUT 	$pole[0], "\t", $pole_group[$pole[1]], "\t", $pole[2], "\t", $pole[3], "\t", 
							$pole[4], "\t", $pole[5], "\t", $pole[6], "\t", $pole[7], "\t", $extrem, "\t", "from ", 
							$max_range, " to ", $max_range + $range_cut, "\t", $max_range_counter, "\t", $F_test, "\n";
		}
		elsif ($CSV_control == 1)
		{
			#######################################PLACE FOR CSV DATA#########################
			# Get data into field
			$CSV_pole[0] = $pole[0];
			$CSV_pole[1] = $pole_group[$pole[1]];
			$CSV_pole[2] = $pole[2];
			$CSV_pole[3] = $pole[3];
			$CSV_pole[4] = $pole[4];
			$CSV_pole[5] = $pole[5];
			$CSV_pole[6] = $pole[6];
			$CSV_pole[7] = $pole[7];
			$CSV_pole[8] = $extrem;
			$CSV_pole[9] = "from " . $max_range . " to " . $max_range + $range_cut;
			$CSV_pole[10] = $max_range_counter;
			$CSV_pole[11] = $F_test;
			# Print pole
			$csv->print($FILE, \@CSV_pole);
		}
		else
		{
			print $FILE 	$pole[0], "\t", $pole_group[$pole[1]], "\t", $pole[2], "\t", $pole[3], "\t", 
							$pole[4], "\t", $pole[5], "\t", $pole[6], "\t", $pole[7], "\t", $extrem, "\t", "from ", 
							$max_range, " to ", $max_range + $range_cut, "\t", $max_range_counter, "\t", $F_test, "\n";
		}	
	}
	#8 Close FILES
	close($FILE);
	close($HIST);
	#9 Return value
	return 1;
}

#ANF 4# - Function for EXPORT RESULTS IN TXT OR CSV - function(database, TYPE, prefix, step_hist, cutOff_log2F, sum_FT, n_DEG_FT, data_from_DB, CSV_control)
#Return: 1 if correct, 0 if incorrect
sub all_export_result_txt 
{
	#1 Get variables
	my $db = shift;				# Database for work
	my $type = shift;			# TYPE - UP/DOWN
	my $nazev = shift;			# Prefix
	my $range_cut = shift;		# Range for histogram
	my $log2F_cut = shift;		# CutOff for log2FoldChange
	my $suma_FT = shift;			# a+b+c+d for Fischers Exact Test
	my $n_DEG_FT = shift;		# a+c for Fischers Exact Test
	my $data = shift;			# Result data from DB
	my $CSV_control = shift;		# CSV control (IF 1 -> CSV OUTPUT)

	#2 Set local fields
	my (@pole_group) = ("UN","CC","MF","BP");
	my @pole;
	my @CSV_pole;

	#3 Set local variables
	my $DEGO_fischer = 0;		# a for FISCHER EXACT TEST
	my $GGO_fischer = 0;			# a+b for FISCHER EXACT TEST
	my $extrem = 0;				# Extrem value for GO term
	my $hist_min;				# First value for computing histogram
	my $max_range = 0;			# Max number genes in range
	my $max_range_counter = 0;	# Counter for max range
	my $F_test;					# Result from fischer exact test
	my $range_counter = 0;		# Members in range
	my $FILE;					# File for primary output
	my $HIST;					# File for histogram
	my $hist_data;				# Data from DB for histogram
	my $hist_var;				# Variable for work with histogram
	my $csv;						# CSV object
	my $head_CSV;				# CSV head for OUT file
	my $CSV_nazev;				# CSV name of file
	my $hist_nazev;				# Name of file for histogram

	#4 Modify nazev
	if ($nazev eq '-')
	{
		$nazev = '-';
	}
	$CSV_nazev = $nazev . "_GO_analysis_all.csv";
	$nazev = $nazev . "_GO_analysis_all.txt";

	#6A PRINT STANDARD OUTPUT HEAD
	if (($nazev eq '-') && ($type eq 'ALL'))
	{
		print STDOUT "Records for all-regulated genes:\n";
		print STDOUT "GO_Level \t Ontology_source \t GO_id \t Description of GO \t Number of GO annotated sequences \t DEGs number \t Percent \t Mean log2FoldChange \t p-value \n";
	}
	#6B CREATE OUTPUT FILE IF SPECIFIED - CSV
	elsif ($CSV_control == 1)
	{
		################################################ CSV PLACE ##############################
		#A Create CSV object
		$csv = Text::CSV->new ( { binary => 1, eol => "\n" } )  # should set binary attribute.
		or die "Cannot use CSV: ".Text::CSV->error_diag (); 
        	#B Create CSV FILE
		open $FILE, ">:encoding(utf8)", $CSV_nazev 
		or die "Test.csv: $!";
		#C Print head into file
		$head_CSV = ([	"GO_Level","Ontology source","GO_id","Description of GO","Number of GO annotated sequences","DEGs number","Percent","Mean log2FoldChange","p-value"]);
		$csv->print($FILE, $head_CSV);
	}
	#6C CREATE OUTPUT FILE IF SPECIFIED - TXT	
	else
	{
		# Create file
		open( $FILE, '>', $nazev)
        	or die "Error: unable to open output file $nazev ($!)";
		# Print head into file
		print $FILE "GO_Level \t Ontology source \t GO_id \t Description of GO \t Number of GO annotated sequences \t DEGs number \t Percent \t Mean log2FoldChange \t p-value \n";;
	}

	#7 PARSING DATA FROM DATAB QUERY
	while (@pole = $data->fetchrow_array)
	{
		#A If data not fullfill option -> NEXT ROW {percent > 0 and number DEG > 0)
		if (!($pole[6] > 0 && $pole[5]))
		{
			next;
		}
		
		#G Get result FISCHER TEST
		$F_test = undef;			# Result of the FISCHER EXACT TEST
		$F_test = (&fischer_test_GO($pole[5],$pole[4],$n_DEG_FT,$suma_FT));
	
		#H PRINT DATA TO STDOUT OR INTO FILE {CSV or TXT}
		if ($nazev eq '-')
		{
			print STDOUT 	$pole[0], "\t", $pole_group[$pole[1]], "\t", $pole[2], "\t", $pole[3], "\t", 
							$pole[4], "\t", $pole[5], "\t", $pole[6], "\t", $pole[7], "\t", $F_test, "\n";
		}
		elsif ($CSV_control == 1)
		{
			#######################################PLACE FOR CSV DATA#########################
			# Get data into field
			$CSV_pole[0] = $pole[0];
			$CSV_pole[1] = $pole_group[$pole[1]];
			$CSV_pole[2] = $pole[2];
			$CSV_pole[3] = $pole[3];
			$CSV_pole[4] = $pole[4];
			$CSV_pole[5] = $pole[5];
			$CSV_pole[6] = $pole[6];
			$CSV_pole[7] = $pole[7];
			$CSV_pole[8] = $F_test;
			# Print pole
			$csv->print($FILE, \@CSV_pole);
		}
		else
		{
			print $FILE 	$pole[0], "\t", $pole_group[$pole[1]], "\t", $pole[2], "\t", $pole[3], "\t", 
							$pole[4], "\t", $pole[5], "\t", $pole[6], "\t", $pole[7], "\t", $F_test, "\n";
		}	
	}
	#8 Close FILES
	close($FILE);
	close($HIST);
	#9 Return value
	return 1;
}

#ANF 5# - Function for calculating p-value by Fischer Exact test - function(a, a+b, a+c, a+b+c+d)
#Return: p-value for selected GO term and cutoff log2fold and p-value, undef value if incorrect
sub fischer_test_GO 
{
	#1 Definition local variables
	my $n11 = shift;		# a
	my $n1p = shift; 	# a + b
	my $np1 = shift;		# a + c
	my $suma = shift;	# a + b + c + d
	my $result = 0;
	my $errorCode;

	#2 Get result for GO term
	$result = Text::NSP::Measures::2D::Fisher2::twotailed::calculateStatistic(n11=>$n11, n1p=>$n1p, np1=>$np1, npp=>$suma);

	#3 Give result or undef value
	if(($errorCode = Text::NSP::Measures::2D::Fisher2::twotailed::getErrorCode()))
	{
		return undef;
	}
	else
	{
		return $result;
	}
}



###################################################################################################
######################################## EXPORTOVACI FUNKCE #######################################
###################################################################################################

#EXP 1# - Export table in tab delimited format TXT - function(database, name, head)
#Return: 1 if correct, 0 if incorrect
sub export_table_txt 
{
	#1 Get local variables
	my $databaze = shift;		# Input database
	my $nazev = shift;			# Name of table
	my $head = shift;				# Head of table
	my $data;							# Data from query
	my $pole;
	my $i = 0;
	my $a = 0;
	my @sloupce;
	
	#2A If query is GO_analysis
	if ($nazev eq '8_GO_analysis') 
	{
		$data = $databaze->prepare("	SELECT 4_term.4_level, 4_term.4_group, 8_GO_analysis.8_seq_name, 8_GO_analysis.8_term_id, 4_term.4_acc, 4_term.4_name
										FROM 4_term, 8_GO_analysis
										WHERE 8_GO_analysis.8_term_id = 4_term.4_id AND 4_term.4_is_obsolete = 0;");
	}
	#2B If query is other table
	else 
	{
		$data = $databaze->prepare("SELECT * FROM $nazev;");
	}
	
	#3 Create output file and processing
	if ($data->execute) 
	{
		#A Create output file
		my $FILE;
		if ($nazev eq '1_Sequence')
		{
			open($FILE, '>', "Sequence_export.fa")
			or die "ERROR: unable to open output file $nazev ($!)";
		}
		else
		{
			if ($nazev eq '2_Hits')
			{
				open($FILE, '>', "Hits_export.txt")
				or die "ERROR: unable to open output file $nazev ($!)";
			}
			elsif ($nazev eq '3_InterProScan_data')
			{
				open($FILE, '>', "InterProScan_data_export.txt")
				or die "ERROR: unable to open output file $nazev ($!)";
			}
			elsif ($nazev eq '6_GO_parse')
			{
				open($FILE, '>', "GO_parse_export.txt")
				or die "ERROR: unable to open output file $nazev ($!)";
			}
			elsif ($nazev eq '8_GO_analysis')
			{
				open($FILE, '>', "GO_analysis_export.txt")
				or die "ERROR: unable to open output file $nazev ($!)";
			}
			else
			{
				return 0;
			}	
			
			#B Print head of file
			print $FILE $head;
		}
		#C Get values from array
		while((@sloupce) = $data->fetchrow_array)
		{	
			# If SEKVENCE
			if ($nazev eq '1_Sequence')
			{
				print $FILE ">", $sloupce[0], "\t Length:", $sloupce[1], "\n";
				print $FILE $sloupce[2], "\n";
				$sloupce[0] = "";
				$sloupce[1] = "";
				$sloupce[2] = "";
				$i++;
			}
			else
			{
				foreach $pole (@sloupce) 
				{
					print $FILE "\t" if($a);
					print $FILE $pole;
					$a++;
				}
				print $FILE "\n";
				$a = 0;
				$i++;
			}	
		}
		#D Print message as out for table
		print STDERR "MESSAGE: For table with name $nazev was export $i records.\n";
		&warr_message("MESSAGE: For table with name $nazev was export $i records.\n");
		#E Close output file
		close($FILE);
		return 1;
	}
	else 
	{
		print STDERR color("red"), "ERROR: Problem in data export for table with name $nazev from database.\n", color("reset");
		&err_message("ERROR: Problem in data export for table with name $nazev from database.\n");
		return 0;
	}
}

#EXP 2# - Export annotation file in TAB delimited format (TXT) - function(database, prefix)
#Return: 1 if correct, 0 if incorrect
sub export_annotation_txt 
{
	#0 Extraction of variables
	my $database = shift;				# Input database
	my $name = shift;					# Prefix name of file
	my $analysis_mode = shift;	# Analysis mode is active

	#1 Declaration of variables
	my $data_DEG;				# Data for DEGs
	my $D_ACT;					# Database action
	my @sloupce;				# Field of DEGs
	my $pole;						# COLLUMN for INSERT into file
	my $BLAST_HIT = '';		#1 BLAST hit
	my $BLAST_AC = '';		#2 BLAST accession
	my $IPR_HIT = '';			#3 IPR hit
	my $IPR_DESC = '';		#4 IPR description
	my $GO_TERM = '';		#5 GO term
	my $GO_MERG = '';		#6 GO merged data
	my $FILE;						# Output FILE
	my $a = 0;						# Counter for DEGs
	
	#2 Get data from DEG table
	if ($analysis_mode == 1)
	{
		$data_DEG = $database->prepare("SELECT * FROM 7_DEG;");
	}
	else
	{
		$data_DEG = $database->prepare('SELECT 1_seq_name FROM 1_Sequence;');
	}
	if ($data_DEG->execute)
	{	
		if ($analysis_mode == 1)
		{
			print STDERR color("green"), "MESSAGE: Proces of export annotation file for DEGs input file was started.\n", color("reset");
            	&err_message("MESSAGE: Proces of export annotation file for DEGs input file was started.\n");
		}
		else
		{
			print STDERR color("green"), "MESSAGE: Proces of export annotation file for sequences in database was started.\n", color("reset");
            &err_message("MESSAGE: Proces of export annotation file for sequences in database was started.\n");
		}
	}
	else
	{
		return 0;
	}
	
	#3 Create OUTPUT file
	open( $FILE, '>', $name)
	or die "Error: unable to open output file $name ($!)";

	#4 Print head of file
	if ($analysis_mode == 1)
	{
		print $FILE 	"Seq_name", "\t", "baseMean", "\t", "Log2FoldChange", "\t", "pValue", "\t", "pAdj", "\t", "Blast_annotation",
			 					"\t", "Blast accession", "\t", "IPR_PFAM_Group", "\t", "IPR_PFAM_Description", "\t", "GO_terms_list", "\n";
	}
	else
	{
		print $FILE 	"Seq_name", "\t", "Blast_annotation", "\t", "Blast accession", "\t", "IPR_PFAM_Group", "\t", "IPR_PFAM_Description", "\t", "GO_terms_list", "\n";
	}
	
	#5 Parsing data with loops
	while((@sloupce) = $data_DEG->fetchrow_array)
	{
		#A Get record for BLAST
		$D_ACT = $database->prepare('SELECT 2_hit_definition, 2_hit_accession FROM 2_Hits WHERE 2_seq_name LIKE "' . $sloupce[0] . '";');
		$D_ACT->execute;
		
		#B Parse data for blast
		if (($D_ACT->{NUM_OF_FIELDS}) > 0)
		{
			($BLAST_HIT, $BLAST_AC) = $D_ACT->fetchrow_array;
		}
		else
		{
			$BLAST_HIT = "";
			$BLAST_AC = "";
		}
		
		#C Get record for IPR
		$D_ACT = $database->prepare('SELECT 3_signature_desc, 3_entry_desc FROM 3_InterProScan_data WHERE 3_database LIKE "PFAM" AND 3_seq_name LIKE "' . $sloupce[0] . '";');
		if (!($D_ACT->execute))
		{
			return 0;
		}
		
		#D Parse data for IPR
		if (($D_ACT->{NUM_OF_FIELDS}) > 0)
		{
			($IPR_HIT, $IPR_DESC) = $D_ACT->fetchrow_array;
		}
		else
		{
			$IPR_HIT = "";
			$IPR_DESC = "";
		}
		
		#E Get records for GO VALUES
		$D_ACT = $database->prepare('SELECT 4_term.4_acc FROM 4_term, 8_GO_analysis WHERE 4_term.4_is_obsolete = 0 AND 8_GO_analysis.8_term_id = 4_term.4_id AND 8_GO_analysis.8_seq_name LIKE "' . $sloupce[0] . '";');
		if (!($D_ACT->execute))
		{
			return 0;
		}
		if (($D_ACT->{NUM_OF_FIELDS}) > 0)
		{
			while ($GO_TERM = $D_ACT->fetchrow_array)
			{
				$GO_MERG = $GO_MERG . $GO_TERM . ",";
			}
		}
		else
		{
			$GO_TERM = "";
			$GO_MERG = "";
		}
		
		#F GIVE values INTO FILE
		foreach $pole (@sloupce)
		{
			print $FILE $pole, "\t";	
		}
		print $FILE $BLAST_HIT, "\t", $BLAST_AC, "\t", $IPR_HIT, "\t", $IPR_DESC, "\t", $GO_MERG, "\n";
		
		#G Reinitialization of values
		$BLAST_HIT = "";
		$BLAST_AC = "";
		$IPR_HIT = "";
		$IPR_DESC = "";
		$GO_MERG = "";
		$GO_TERM = "";

		#H Print message if 1000 lines are processed
		$a++;
                if (!($a%100))
                {
                        print STDERR $a, " records in annotation file export is processed.\n";
                }
	}
	
	#7 Close OUTPUT file and return
	close($FILE);
	return 1;
}

###################################################################################################
############################### WARRINGS FUNCTIONS ################################################
###################################################################################################

#WARR 1# - Function for message description into log file - function(text_of_message)
#Return: 0
sub warr_message 
{
	#1 Variable
	my $zprava = shift;
	
	#2 Open FILE
	open( my $FILE, '>>', "log.txt");
	
	#3 Get time and day
	(my $sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);

	#4 Send message into file
	printf $FILE "[%4d-%02d-%02d %02d:%02d:%02d] ",$year+1900,$mon+1,$mday,$hour,$min,$sec;
	print $FILE "$zprava";

	#5 Close file and return
	close $FILE;
	return 0;
}

#WARR 2# - Function for error description into errorfile - function(text_of_message)
#Return: 0
sub err_message 
{
	#1 Variable
	my $zprava = shift;
	
	#2 Open FILE
	open( my $FILE, '>>', "error.log");
	
	#3 Get time and day
	(my $sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);

	#4 Send message into file
	printf $FILE "[%4d-%02d-%02d %02d:%02d:%02d] ",$year+1900,$mon+1,$mday,$hour,$min,$sec;
	print $FILE "$zprava";

	#5 Close file and return
	close $FILE;
	return 0;
}

#WARR 3# - Function for stat file export - function(host, name, user, passwd, analysis)
sub stat_file
{
	#1 Variables
	my $host = shift;
	my $name = shift;
	my $user = shift;
	my $pass = shift;
	my $analysis = shift;
	my $pAdj = shift;
	my $log2F = shift;
	
	my $db = undef;			# Database
	my $total_seq = 0;		# Total seqs in DB
	my $count = 0;				# Count of sequence
	my $query = "";			# Query for database 
	
	my $blast_annot = 0;	# Genes with annotation for BLAST
	my $ipr_annot = 0;		# Genes with annotation for IPR
	my $no_annot = 0;		# Genes without annotation

	#2 Open file
	open (my $FILE, '>', "stat.log");

	#3 Get acces to database
	$db = &datab::pristup($host, $name, $user, $pass);
	if (!(defined($db)))
    	{
                exit (0);       # If problem then exit
    	}
	
	#4 Query total count
	$total_seq = $db->do("SELECT 1_seq_name FROM 1_Sequence;");
	print $FILE "In database are currently stored: $total_seq sequences of which:\n";

	#5 Query BLAST annotation
	$blast_annot = $db->do("SELECT DISTINCT 2_seq_name FROM 2_Hits;");
	if ($blast_annot == 1)
	{
		print $FILE "$blast_annot sequence has BLAST annotation.\n";
	}
	else
	{
		print $FILE "$blast_annot sequences have BLAST annotation.\n";
	}

	#6 Query GO annotation
    	$count = $db->do("SELECT DISTINCT 8_seq_name FROM 8_GO_analysis;");
	if ($count == 1)
	{
    		print $FILE "$count sequence has GO annotation.\n";
	}
	else
	{
		print $FILE "$count sequences have GO annotation.\n";
	}

	#7 Query IPR annotation
    	$ipr_annot = $db->do("SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data;");
	if ($ipr_annot == 1)
	{
    		print $FILE "$ipr_annot sequence has InterProScan annotation.\n";
	}
	else
	{
		print $FILE "$ipr_annot sequences have InterProScan annotation.\n";
	}
	
	# GENE3D
	$count = $db->do('SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data WHERE 3_database = "GENE3D";');
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has GENE3D annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have GENE3D annotation from InterProScan search.\n";
	}
	# PANTHER
	$count = $db->do('SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data WHERE 3_database = "PANTHER";');
    	 if ($count == 1)
	{
		print $FILE "\t$count sequence has PANTHER annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have PANTHER annotation from InterProScan search.\n";
	}
	# PFAM
	$count = $db->do('SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data WHERE 3_database = "PFAM";');
    if ($count == 1)
	{
		print $FILE "\t$count sequence has PFAM annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have PFAM annotation from InterProScan search.\n";
	}
	# PHOBIUS
	$count = $db->do('SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data WHERE 3_database = "PHOBIUS";');
    if ($count == 1)
	{
		print $FILE "\t$count sequence has PHOBIUS annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have PHOBIUS annotation from InterProScan search.\n";
	}
	# PRINTS
	$count = $db->do('SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data WHERE 3_database = "PRINTS";');
    if ($count == 1)
	{
		print $FILE "\t$count sequence has PRINTS annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have PRINTS annotation from InterProScan search.\n";
	}
	# PROSITE_PATTERNS
	$count = $db->do('SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data WHERE 3_database = "PROSITE_PATTERNS";');
    if ($count == 1)
	{
		print $FILE "\t$count sequence has PROSITE_PATTERNS annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have PROSITE_PATTERNS annotation from InterProScan search.\n";
	}
	# SIGNALP_EUK
	$count = $db->do('SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data WHERE 3_database = "SIGNALP_EUK";');
    if ($count == 1)
	{
		print $FILE "\t$count sequence has SIGNALP_EUK annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have SIGNALP_EUK annotation from InterProScan search.\n";
	}
	# SIGNALP_GRAM_NEGATIVE
	$count = $db->do('SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data WHERE 3_database = "SIGNALP_GRAM_NEGATIVE";');
    if ($count == 1)
	{
		print $FILE "\t$count sequence has SIGNALP_GRAM_NEGATIVE annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have SIGNALP_GRAM_NEGATIVE annotation from InterProScan search.\n";
	}
	# SIGNALP_GRAM_POSITIVE
	$count = $db->do('SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data WHERE 3_database = "SIGNALP_GRAM_POSITIVE";');
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has SIGNALP_GRAM_POSITIVE annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have SIGNALP_GRAM_POSITIVE annotation from InterProScan search.\n";
	}
	# SMART
	$count = $db->do('SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data WHERE 3_database = "SMART";');
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has SMART annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have SMART annotation from InterProScan search.\n";
	}
	# SUPERFAMILY
	$count = $db->do('SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data WHERE 3_database = "SUPERFAMILY";');
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has SUPERFAMILY annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have SUPERFAMILY annotation from InterProScan search.\n";
	}
	# COILS
	$count = $db->do('SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data WHERE 3_database = "COILS";');
    if ($count == 1)
	{
		print $FILE "\t$count sequence has COILS annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have COILS annotation from InterProScan search.\n";
	}
	# HAMAP
	$count = $db->do('SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data WHERE 3_database = "HAMAP";');
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has HAMAP annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have HAMAP annotation from InterProScan search.\n";
	}
	# PROSITE_PROFILES
	$count = $db->do('SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data WHERE 3_database = "PROSITE_PROFILES";');
    if ($count == 1)
	{
		print $FILE "\t$count sequence has PROSITE_PROFILES annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have PROSITE_PROFILES annotation from InterProScan search.\n";
	}
	# TIGRFAM
	$count = $db->do('SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data WHERE 3_database = "TIGRFAM";');
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has TIGRFAM annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have TIGRFAM annotation from InterProScan search.\n";
	}
	# TMHMM
	$count = $db->do('SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data WHERE 3_database = "TMHMM";');
    if ($count == 1)
	{
		print $FILE "\t$count sequence has TMHMM annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have TMHMM annotation from InterProScan search.\n";
	}
	# PIRSF
	$count = $db->do('SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data WHERE 3_database = "PIRSF";');
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has PIRSF annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have PIRSF annotation from InterProScan search.\n";
	}
	# PRODOM
	$count = $db->do('SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data WHERE 3_database = "PRODOM";');
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has PRODOM annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have PRODOM annotation from InterProScan search.\n";
	}
	 
	#8 Genes without annotation
	if ($blast_annot >= $ipr_annot)
	{
		$count = $db->do("SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 2_Hits WHERE 2_seq_name = 3_seq_name;");
		$no_annot = $total_seq - ($blast_annot + ($ipr_annot - $count));
	}
	else
	{
		$count = $db->do("SELECT DISTINCT 2_seq_name FROM 3_InterProScan_data, 2_Hits WHERE 2_seq_name = 3_seq_name;");
		$no_annot = $total_seq - ($ipr_annot + ($blast_annot - $count));
	}
	if ($no_annot == 1)
	{
		print $FILE "$no_annot sequence has no annotation.\n";
	}
	else
	{
		print $FILE "$no_annot sequences have no annotation.\n";
	}

	#9 If ANALYSIS MODE is inactive
	if ($analysis == 0)
	{
		print STDERR "MESSAGE: Statistics is exported as stat.log file.\n";
		return 1;
	}
	
	#10 If ANALYSIS MODE is active
	$total_seq = 0;
	$no_annot = 0;
	$total_seq = $db->do("SELECT DISTINCT 7_seq_name FROM 7_DEG WHERE 7_padj <= $pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);");
	print $FILE "\n\nAnnotation results for differentially expressed genes/sequences are:\n";

	#11 Query BLAST annotation
	$blast_annot = $db->do("SELECT DISTINCT 2_seq_name FROM 2_Hits, 7_DEG WHERE 2_seq_name = 7_seq_name AND 7_padj <= $pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);");
	if ($blast_annot == 1)
	{
			print $FILE "$blast_annot sequence has BLAST annotation.\n";
	}
	else
	{
			print $FILE "$blast_annot sequences have BLAST annotation.\n";
	}

	#12 Query GO annotation
    	$count = $db->do("SELECT DISTINCT 8_seq_name FROM 8_GO_analysis, 7_DEG WHERE 8_seq_name = 7_seq_name AND 7_padj <= $pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);");
    	if ($count == 1)
	{
		print $FILE "$count sequence has GO annotation.\n";
	}
	else
	{
		print $FILE "$count sequences have GO annotation.\n";
	}

	#13 Query IPR annotation
    	$ipr_annot = $db->do("SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG WHERE 3_seq_name = 7_seq_name AND 7_padj <= $pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);");
    	if ($ipr_annot == 1)
	{
		print $FILE "$ipr_annot sequence has InterProScan annotation.\n";
	}
	else
	{
		print $FILE "$ipr_annot sequences have InterProScan annotation.\n";
	}
	
	#14 IPR PARTIAL DATABASES
	# GENE3D
	$query = 'SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG WHERE 3_database = "GENE3D" AND 3_seq_name = 7_seq_name AND 7_pAdj <= ' . "$pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);";
	$count = $db->do($query);
    if ($count == 1)
	{
		print $FILE "\t$count sequence has GENE3D annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have GENE3D annotation from InterProScan search.\n";
	}
	# PANTHER
	$query = 'SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG WHERE 3_database = "PANTHER" AND 3_seq_name = 7_seq_name AND 7_pAdj <= ' . "$pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);";
	$count = $db->do($query);
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has PANTHER annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have PANTHER annotation from InterProScan search.\n";
	}
	# PFAM
	$query = 'SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG WHERE 3_database = "PFAM" AND 3_seq_name = 7_seq_name AND 7_pAdj <= ' . "$pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);";
	$count = $db->do($query);
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has PFAM annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have PFAM annotation from InterProScan search.\n";
	}
	# PHOBIUS
	$query = 'SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG WHERE 3_database = "PHOBIUS" AND 3_seq_name = 7_seq_name AND 7_pAdj <= ' . "$pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);";
	$count = $db->do($query);
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has PHOBIUS annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have PHOBIUS annotation from InterProScan search.\n";
	}
	# PRINTS
	$query = 'SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG WHERE 3_database = "PRINTS" AND 3_seq_name = 7_seq_name AND 7_pAdj <= ' . "$pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);";
	$count = $db->do($query);
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has PRINTS annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have PRINTS annotation from InterProScan search.\n";
	}
	# PROSITE_PATTERNS
	$query = 'SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG WHERE 3_database = "PROSITE_PATTERNS" AND 3_seq_name = 7_seq_name AND 7_pAdj <= ' . "$pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);";
	$count = $db->do($query);
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has PROSITE_PATTERNS annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have PROSITE_PATTERNS annotation from InterProScan search.\n";
	}
	# SIGNALP_EUK
	$query = 'SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG WHERE 3_database = "SIGNALP_EUK" AND 3_seq_name = 7_seq_name AND 7_pAdj <= ' . "$pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);";
	$count = $db->do($query);
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has SIGNALP_EUK annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have SIGNALP_EUK annotation from InterProScan search.\n";
	}
	# SIGNALP_GRAM_NEGATIVE
	$query = 'SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG WHERE 3_database = "SIGNALP_GRAM_NEGATIVE" AND 3_seq_name = 7_seq_name AND 7_pAdj <= ' . "$pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);";
	$count = $db->do($query);
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has SIGNALP_GRAM_NEGATIVE annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have SIGNALP_GRAM_NEGATIVE annotation from InterProScan search.\n";
	}
	# SIGNALP_GRAM_POSITIVE
	$query = 'SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG WHERE 3_database = "SIGNALP_GRAM_POSITIVE" AND 3_seq_name = 7_seq_name AND 7_pAdj <= ' . "$pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);";
	$count = $db->do($query);
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has SIGNALP_GRAM_POSITIVE annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have SIGNALP_GRAM_POSITIVE annotation from InterProScan search.\n";
	}
	# SMART
	$query = 'SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG WHERE 3_database = "SMART" AND 3_seq_name = 7_seq_name AND 7_pAdj <= ' . "$pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);";
	$count = $db->do($query);
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has SMART annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have SMART annotation from InterProScan search.\n";
	}
	# SUPERFAMILY
	$query = 'SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG WHERE 3_database = "SUPERFAMILY" AND 3_seq_name = 7_seq_name AND 7_pAdj <= ' . "$pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);";
	$count = $db->do($query);
    	if ($count == 01)
	{
		print $FILE "\t$count sequence has SUPERFAMILY annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have SUPERFAMILY annotation from InterProScan search.\n";
	}
	# COILS
	$query = 'SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG WHERE 3_database = "COILS" AND 3_seq_name = 7_seq_name AND 7_pAdj <= ' . "$pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);";
	$count = $db->do($query);
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has COILS annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have COILS annotation from InterProScan search.\n";
	}
	# HAMAP
	$query = 'SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG WHERE 3_database = "HAMAP" AND 3_seq_name = 7_seq_name AND 7_pAdj <= ' . "$pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);";
	$count = $db->do($query);
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has HAMAP annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have HAMAP annotation from InterProScan search.\n";
	}
	# PROSITE_PROFILES
	$query = 'SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG WHERE 3_database = "PROSITE_PROFILES" AND 3_seq_name = 7_seq_name AND 7_pAdj <= ' . "$pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);";
	$count = $db->do($query);
    if ($count == 1)
	{
		print $FILE "\t$count sequence has PROSITE_PROFILES annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have PROSITE_PROFILES annotation from InterProScan search.\n";
	}
	# TIGRFAM
	$query = 'SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG WHERE 3_database = "TIGRFAM" AND 3_seq_name = 7_seq_name AND 7_pAdj <= ' . "$pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);";
	$count = $db->do($query);
    if ($count == 1)
	{
		print $FILE "\t$count sequence has TIGRFAM annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have TIGRFAM annotation from InterProScan search.\n";
	}
	# TMHMM
	$query = 'SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG WHERE 3_database = "TMHMM" AND 3_seq_name = 7_seq_name AND 7_pAdj <= ' . "$pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);";
	$count = $db->do($query);
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has TMHMM annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have TMHMM annotation from InterProScan search.\n";
	}
	# PIRSF
	$query = 'SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG WHERE 3_database = "PIRSF" AND 3_seq_name = 7_seq_name AND 7_pAdj <= ' . "$pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);";
	$count = $db->do($query);
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has PIRSF annotation from InterProScan search.\n";
	}
	else
	{
		print $FILE "\t$count sequences have PIRSF annotation from InterProScan search.\n";
	}
	# PRODOM
	$query = 'SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG WHERE 3_database = "PRODOM" AND 3_seq_name = 7_seq_name AND 7_pAdj <= ' . "$pAdj AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);";
	$count = $db->do($query);
    	if ($count == 1)
	{
		print $FILE "\t$count sequence has PRODOM annotation from InterProScan search.\n";	
	}
	else
	{
		print $FILE "\t$count sequences have PRODOM annotation from InterProScan search.\n";	
	}
		
	#15 Genes without annotation
	if ($blast_annot >= $ipr_annot)
	{
		$count = $db->do("SELECT DISTINCT 3_seq_name FROM 3_InterProScan_data, 7_DEG, 2_Hits WHERE 3_seq_name = 7_seq_name AND 7_padj <= $pAdj AND 2_seq_name = 3_seq_name AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);");
		$no_annot = $total_seq - ($blast_annot + ($ipr_annot - $count));
	}
	else
	{
		$count = $db->do("SELECT DISTINCT 2_seq_name FROM 2_Hits, 7_DEG, 3_InterProScan_data WHERE 2_seq_name = 7_seq_name AND 7_padj <= $pAdj AND 2_seq_name = 3_seq_name AND (7_log2FoldChange >= $log2F OR 7_log2FoldChange <= -$log2F);");
		$no_annot = $total_seq - ($ipr_annot + ($blast_annot - $count));
	}
	if ($no_annot == 1)
	{
		print $FILE "$no_annot sequence has no annotation.\n";
	}
	else
	{
		print $FILE "$no_annot sequences have no annotation.\n";
	}
	return 1;
}
1;
