/*
    Bazoo_worms the game
    Copyright (C) 2011  Pavel Prochazka

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef WORM_H
#define WORM_H

typedef struct WRMS_worm_state
{
  const char *img;
  const char *animation;
  const char *audio;
} WRMS_worm_state;

typedef enum
{
  WRMS_HUMAN = 0x0,
  WRMS_COMPUTER,
  WRMS_NET
} WRMS_player_types;

typedef struct WRMS_worm_player
{
  SPRITE *active_gun;
  int turns_p;
  WRMS_player_types player_type;
  int team_id;
  char *name;
  int health;
  int got_damage;
} WRMS_worm_player;

typedef enum
{ ON_LANDSCAPE = 0x0, IN_AIR } PHYS_STATES;

typedef struct WRMS_worm
{

  PHYS_STATES phys_state;
  WORM_STATES worm_state;

  int direction;
  int space_toggle;		/* if we are touching SPACE key - see controll.c */
  WRMS_worm_player player_spec;
} WRMS_worm;

//typedef enum { WORM_IDLE = 0x0 , WORM_IDLE_LEFT , WORM_IDLE_RIGHT ,WORM_MOVING_LEFT , WORM_MOVING_RIGHT , WORM_JUMPING_LEFT , WORM_JUMPING_RIGHT  }WORM_STATES;
int WRMS_worm_fixed_p (SPRITE * self);

WRMS_worm *WRMS_get_worm_desc (SPRITE * self);
void WRMS_worm_set_turns_p (SPRITE * self, int turns_p);
SPRITE *WRMS_worm_make (int x, int y);
int WRMS_worm_health (SPRITE * worm);
WRMS_worm_player *WRMS_worm_get_player (SPRITE * worm);
SPRITE *WRMS_worm_get_current_gun (SPRITE * worm);

void WRMS_worm_play_done (SPRITE * self);

#endif
