/*
    Bazoo_worms the game
    Copyright (C) 2011  Pavel Prochazka

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef WEAPON_H
#define WEAPON_H

typedef struct WRMS_gun
{
  char *gun_prefix;
  int ammo;

  void (*on_draw) (SPRITE *);
  void (*sighting) (SPRITE *);
  void (*fire) (SPRITE *);
    POINT (*simulate_fire) (SPRITE *, VECTOR, float);
  float (*compute_damage) (SPRITE * self, SPRITE * victim, POINT impact);
} WRMS_gun;

typedef struct WRMS_gun_desc
{
  int ammo_left;
  SPRITE *owner;
  VECTOR angle;
  WRMS_gun gun_vtbl;
  WORM_STATES gun_state;
  float power;
  int vtbl_idx;
} WRMS_gun_desc;


typedef enum
{ BAZOOKA = 0x0, SHOTGUN } WRMS_gun_type;

float bazooka_compute_damage_impl (SPRITE * self, SPRITE * victim,
				   POINT impact);

WRMS_gun_desc *WRMS_get_gun_desc (SPRITE * gun);
SPRITE *WRMS_gun_make (WRMS_gun_type gun_definition);
WRMS_gun_desc *WRMS_gun_get_desc (SPRITE * gun);
DIRECTION WRMS_gun_get_direction (SPRITE * gun);

const char *WRMS_gun_string (WRMS_gun_type g_type);

int WRMS_worm_set_gun (SPRITE * worm, WRMS_gun_type g_type);
void WRMS_worm_unset_gun (SPRITE * worm);
SPRITE *WRMS_worm_get_gun (SPRITE * worm);
void WRMS_worm_controll_gun_impl (SPRITE * worm);
POINT WRMS_gun_simulate_fire (SPRITE * self, VECTOR v, float power);
float WRMS_gun_compute_damage (SPRITE * gun, SPRITE * victim, POINT impact);

void WRMS_gun_update_drawing (SPRITE * worm);
void WRMS_gun_fire (SPRITE * worm);

VECTOR WRMS_gun_get_angle (SPRITE * gun);
VECTOR WRMS_gun_increase_angle (SPRITE * gun);
VECTOR WRMS_gun_decrease_angle (SPRITE * gun);
void WRMS_gun_set_angle (SPRITE * gun, VECTOR v, DIRECTION d);

float WRMS_gun_set_power (SPRITE * gun, float power);
float WRMS_gun_increase_power (SPRITE * gun);
float WRMS_gun_get_power (SPRITE * gun);
void WRMS_gun_reset_power (SPRITE * gun);

PHYSICS WRMS_firepower (float m, VECTOR v, float power);

#endif
