/*
    Bazoo_worms the game
    Copyright (C) 2011  Pavel Prochazka

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef RULES_H
#define RULES_H

#define TIME_LIMIT 20000

typedef struct WRMS_team
{
  LIST *teammates;
  int initial_teammates_count;
  SDL_Color c;
  char *team_name;
  WRMS_player_types type;
} WRMS_team;

WRMS_team *WRMS_worm_team (SPRITE * worm);
SPRITE *WRMS_team_add_player (WRMS_team * t, SPRITE * worm);
SPRITE *WRMS_team_die_player (WRMS_team * t, SPRITE * worm);
int WRMS_team_health (WRMS_team * t);
int WRMS_team_players_count (WRMS_team * t);

int WRMS_ai_micro_brain (SPRITE * worm, WORM_STATES * ws,
			 int gun_controlling_p);

int WRMS_game_begin (LIST * teams, int beginning_team);

LIST *WRMS_rules_teams ();
void WRMS_rules_refresh ();

SPRITE *WRMS_rules_swap_players ();
void WRMS_rules_update_worms_health ();
void WRMS_rules_clear ();
int WRMS_rules_game_done_p ();
WRMS_team *WRMS_get_win_team ();
void WRMS_rules_set_active_player (SPRITE * player);
void WRMS_rules_register_player (SPRITE * player);
void WRMS_rules_unregister_player (SPRITE * player);
int WRMS_rules_get_damage (SPRITE * self);
Uint32 WRMS_rules_remaining ();
void WRMS_rules_increase_worm_time (SPRITE * worm);

LIST *WRMS_rules_worms ();
SPRITE *WRMS_rules_active_worm ();


int WRMS_rules_can_play_p (SPRITE * player);
int WRMS_rules_decrease_ammo_count (SPRITE * player);
int WRMS_rules_can_fire_p (SPRITE * player);
int WRMS_rules_fired_signal (SPRITE * player);
int WRMS_rules_damage_signal (SPRITE * attacker, SPRITE * victim);
void WRMS_rules_fire_done_signal ();
WRMS_team *WRMS_rules_active_team ();

int WRMS_rules_give_damage (SPRITE * attacker, SPRITE * victim, int hp);
int WRMS_rules_compute_health (SPRITE * victim);


#endif
