/*
    Bazoo_worms the game
    Copyright (C) 2011  Pavel Prochazka

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "MG_lib.h"
#include "WRMS_include.h"

SPRITE *
WRMS_player_implicit_guns (SPRITE * worm)
{
  MG_set_key (worm, WRMS_gun_string (BAZOOKA), WRMS_gun_make (BAZOOKA));
  return worm;
}

WRMS_worm_player *
WRMS_worm_get_player (SPRITE * worm)
{
  WRMS_worm *w = WRMS_get_worm_desc (worm);
  return &(w->player_spec);
}

SPRITE *
WRMS_player_make (const char *name, WRMS_team * team, int begins_p)
{
  WRMS_player_types type = team->type;

  SPRITE *landscape = WRMS_landscape_get ();
  SPRITE *out = NULL;
  int x, y;
  float ratio = (float) (rand () % 100) / 100;
  WRMS_worm_player p =
    { NULL, begins_p, type, (int) team, (name ? strdup (name) : NULL), 100 };
  WRMS_worm *w = NULL;

  out = WRMS_worm_make (0, 0);
  w = WRMS_get_worm_desc (out);
  w->player_spec = p;

  x =
    landscape->dest.x + out->dest.w +
    (ratio * (landscape->dest.w - (2 * out->dest.w)));
  y = landscape->dest.y - out->dest.h;

  MG_move_sprite (out, x, y);

  WRMS_player_implicit_guns (out);
  WRMS_worm_set_gun (out, BAZOOKA);

  /* add information on worm */
  char h[25];
  sprintf (h, "%d", p.health);

  SPRITE *name_text = WRMS_text (name, team->c, 10, WRMS_FONT);
  SPRITE *health = WRMS_text (h, team->c, 10, WRMS_FONT);

  MG_attach_sprite (out, name_text, 0, 0);
  sprite_align_mid (name_text, out);
  MG_move_sprite (name_text, 0, -26);

  MG_set_key (out, "title_sprite", name_text);

  MG_attach_sprite (out, health, 0, 0);
  sprite_align_mid (health, out);
  MG_move_sprite (health, 0, -36);

  MG_set_key (out, "worm_health", health);

  WRMS_team_add_player (team, out);
  WRMS_rules_register_player (out);

  return out;
}

void
WRMS_player_destroy (SPRITE * worm)
{
  printf ("FIXME\n");
}

char *
WRMS_player_name (SPRITE * worm)
{
  WRMS_worm_player *pl = WRMS_worm_get_player (worm);
  return pl->name;
}
