/*
This file is part of MGEAN library.

MGEAN library is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

MGEAN library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with MGEAN library.  If not, see <http://www.gnu.org/licenses/>.

Copyright 2010-2011 Pavel Procházka
*/
#include <stdio.h>
#include <SDL/SDL.h>
#include <SDL/SDL_mixer.h>
#include "audio.h"
#include "list.h"

void
MG_play_music (int *channel, int ms_expire, int current_time, Mix_Chunk * m)
{
  if ((current_time < ms_expire) || !m)
    return;

  if (*channel == -1)
    {
      *channel = Mix_PlayChannelTimed (-1, m, 1, ms_expire);
      printf ("got channel: %d\n", *channel);
    }
  else
    {
      Mix_HaltChannel (*channel);
      Mix_PlayChannelTimed (*channel, m, 1, ms_expire);
    }
}
