/*
    Bazoo_worms the game
    Copyright (C) 2011  Pavel Prochazka

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "time.h"
#include "MG_lib.h"
#include "WRMS_include.h"
#include "background.h"
#include "landscape.h"
#include "map.h"

const WRMS_MAP implicit_map = { "background.png", "tropical.png" };

static WRMS_MAP g_map = { "background.png", "tropical.png" };

WRMS_MAP *
WRMS_map ()
{
  return &g_map;
}

int
WRMS_set_map (WRMS_MAP map)
{
  g_map = map;
  return 0;
}

int
WRMS_load_map (const char *path)
{
  WRMS_MAP w_map;

  if (!path)
    {
      w_map = implicit_map;
      srand (clock ());

      HASH *maps = MG_text_list (MAP_LIST);
      LIST *map_list = maps->values;

      int len = MG_list_length (map_list);
      int nth = rand () % len;
      HASH *m = MG_list_nth (map_list, nth);
      char *path = (char *) m->values;

      WRMS_set_background (w_map.background);
      SPRITE *landscape = WRMS_landscape_build (path);
      if (!landscape)
	return -1;

      MG_hash_free (maps);

      return WRMS_set_map (w_map);
    }
  return -1;
}
