/*
    Bazoo_worms the game
    Copyright (C) 2011  Pavel Prochazka

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef WIN32
#include <unistd.h>
#endif

#include "MG_lib.h"
#include "SDL/SDL.h"
#include "SDL/SDL_mixer.h"
#include "WRMS_include.h"

#if WIN32
int
WinMain (void *hInstance, void *hPrevInstance, void *lpCmdLine, int nCmdShow)
#else
int
main (int argc, char *argv[])
#endif
{
#ifndef WIN32
  char *parent_path = WRMS_parent_path (argv[0]);
  printf ("info: changing directory to implicit game data path\n");
  int rslt = chdir (parent_path);
  free (parent_path);
  if (rslt)
    exit (-1);
#endif

  /* tests */
  VECTOR v = { 1.0f, 0.0f };
  vector_print (rotate_vector (v, -4.0f));

  SDL_Rect r1 = { 10, 10, 30, 30 };
  SDL_Rect r2 = { 11, 11, 20, 20 };

  SDL_Rect out = rects_cut (r1, r2);
  print_rect (out);

  Uint32 flags = SDL_SWSURFACE | SDL_FULLSCREEN;

#ifndef WIN32
  if (argc == 2)
    {
      if (!strcmp (argv[1], "--windowed"))
	{
	  flags &= ~SDL_FULLSCREEN;
	}
    }
#endif

  SDL_Rect **modes = NULL;

  SDL_Rect best_mode = rect (0, 0, 0, 0);
  SDL_Rect world_rect = WRMS_WORLD_SCREEN;

  if (!SDL_Init (SDL_INIT_VIDEO) && !TTF_Init ())
    {
      modes = SDL_ListModes (NULL, SDL_FULLSCREEN | SDL_SWSURFACE);

      if (modes != (SDL_Rect **) - 1)
	{
	  int i;
	  for (i = 0; modes[i]; i++)
	    {
	      printf ("mode: %dx%d\n", modes[i]->w, modes[i]->h);
	      SDL_Rect current = *(modes[i]);
	      if (current.w > best_mode.w && current.h > best_mode.h)
		{
		  if (!
		      (current.w >= world_rect.w
		       || current.h >= world_rect.h))
		    {
		      best_mode = current;
		    }
		}
	    }
	}
      else if (!modes)
	{
	  printf ("err: no mode graphic mode available\n");
	  return -1;
	}

      if (best_mode.w < 800 || best_mode.h < 600)
	{
	  printf
	    ("err: too low best resolution configure your system to have at least 800x600!\n");
	  return -1;
	}

      printf ("video was successfully created\n");
      printf ("best mode is: %dx%d\n", best_mode.w, best_mode.h);
    }
  else
    {
      SDL_Quit ();
      return -1;
    }

  MG_init_video (best_mode.w, best_mode.h, flags);
  MG_set_world (2048, 1600);
  SDL_WM_SetCaption ("Bazoo_worms devel mode", NULL);

  int result = WRMS_init_system (NULL);

  if (!result)
    {
      printf ("fatal: can not load all resources! ... quitting\n");
      WRMS_deinit_system ();
      SDL_Quit ();
      return -1;
    }

  WRMS_enter_rendering ();	/* main loop */
  WRMS_deinit_system ();

  return 0;
}
