/*
    Bazoo_worms the game
    Copyright (C) 2011  Pavel Prochazka

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "MG_lib.h"
#include "WRMS_include.h"

int
WRMS_init_system (const char *confpath)
{
  char *conf_string = NULL;

  int result = 1;

  if (confpath)
    conf_string = file_read (confpath);
  else
    conf_string = strdup (IMPLICIT_GAME_CONF);

  if (!conf_string)
    return 0;

  HASH *conf = MG_text_list (conf_string);
  free (conf_string);
  conf_string = NULL;

  HASH *fonts = MG_hash_get_key (conf, ":fonts");
  HASH *images = MG_hash_get_key (conf, ":images");
  LIST *f_it = fonts->values;

  while (f_it)
    {
      HASH *fnt_name = (HASH *) f_it->value;
      char *font_name = (char *) fnt_name->values;

      TTF_Font *f = TTF_OpenFont (font_name, 20);
      if (!f)
	{
	  printf ("err: can not resolve font: %s\n", font_name);
	  result = 0;
	}
      else
	{
	  printf ("info: font %s is available\n", font_name);
	  TTF_CloseFont (f);
	}

      f_it = f_it->node;
    }

  LIST *im_it = images->values;

  while (im_it)
    {
      HASH *im = (HASH *) im_it->value;
      char *path = (char *) im->values;
      int res = MG_preload_img (path);

      if (res < 0)
	{
	  result = 0;
	  printf ("warn: img %s can not be loaded ... [FAIL]\n", path);
	}
      else
	{
	  printf ("info: image: %s ... [OK]\n", path);
	}

      im_it = im_it->node;
    }

  MG_hash_free (conf);
  return result;
}

int
WRMS_deinit_system ()
{
  WRMS_font_cache_clear ();
  MG_quit ();
  printf ("bye\n");
  return 0;
}
