/*
    Bazoo_worms the game
    Copyright (C) 2011  Pavel Prochazka

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef GUI_H
#define GUI_H

typedef struct WRMS_timer
{
  int ticks;
  int max_ticks;
  void (*func) (SPRITE * self, void *args);
  void *args;
} WRMS_timer;

typedef enum WRMS_container_type
{ WRMS_CONTAINER_VERTICAL =
    1, WRMS_CONTAINER_HORIZONTAL } WRMS_container_type;

void WRMS_widget_center (SPRITE * owner, SPRITE * centralized);
SPRITE *WRMS_widget_make (SDL_Surface * img, SDL_Rect * r,
			  const char *symb_name);
SPRITE *WRMS_widget_bind (SPRITE * owner, SPRITE * attachment);
SPRITE *WRMS_widget_parent (SPRITE * self);
SPRITE *WRMS_widget_unbind (SPRITE * owner, SPRITE * attachment);
void WRMS_widget_install_timer (SPRITE * widget, int ticks,
				void (*func) (SPRITE *, void *), void *args);
SPRITE *WRMS_container_make (SDL_Surface * bckg, WRMS_container_type t);
void WRMS_container_clear (SPRITE * container);

SPRITE *WRMS_widget_text (const char *title, const char *font, int size,
			  SDL_Color c);
void WRMS_update_text (SPRITE * wtext, SDL_Color c, Uint16 size,
		       const char *txt);
SPRITE *WRMS_textarea_make (const char *txt);
SPRITE *WRMS_dialog_make (const char *title, int w, int h);
SPRITE *WRMS_dialog_body (SPRITE * dialog);
SPRITE *WRMS_dialog_buttons (SPRITE * dialog);
SPRITE *WRMS_button_make (const char *title, SDL_Surface * background,
			  SDL_Color c);

SPRITE *WRMS_edit_box_make (int w, int h, int max_chars);
char *WRMS_edit_box_set_text (SPRITE * editbox, const char *txt);
char *WRMS_edit_box_get_text (SPRITE * editbox);
SPRITE *WRMS_dialog_error (const char *title, const char *body);
SPRITE *WRMS_dialog_yesno (const char *title, const char *question);

int WRMS_get_screen_w ();
int WRMS_get_screen_h ();

#endif
