/*
    Bazoo_worms the game
    Copyright (C) 2011  Pavel Prochazka

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <string.h>
#include "MG_lib.h"
#include "WRMS_include.h"

static const char *direction_table[] = {
  "left",
  "top",
  "right",
  "bottom"
};

static const char *action_table[] = {
  "moving",
  "jumping",
  "firing",
  "idling",
  "bored",
  "explosing",
  "dying"
};

/*
  builds name in format "prefix_action_direction.suffix" 
  output must be freed
  both direction and action are optional, only if value is higher will be passed
  if direction or action will not be accessed then the string will be without _
  suffix is optional too
*/
char *
WRMS_build_name (DIRECTION direction, ACTION action, const char *prefix,
		 const char *suffix)
{
  const char *dir = (direction < 0 ? "" : direction_table[direction]);
  const char *act = (action < 0 ? "" : action_table[action]);
  const char *my_suffix = (suffix ? suffix : "");
  unsigned int len =
    strlen (dir) + strlen (act) + strlen (prefix) + strlen (my_suffix) + 3 +
    1;

  char *out = (char *) malloc (sizeof (char) * (len));

  memset (out, 0, len);
  strcat (out, prefix);

  if (*act)
    {
      strcat (out, "_");
      strcat (out, act);
    }

  if (*dir)
    {
      strcat (out, "_");
      strcat (out, dir);
    }

  if (suffix)
    {
      if (*suffix)
	{
	  strcat (out, ".");
	  strcat (out, suffix);
	}
    }
  return out;
}
