/*
    Bazoo_worms the game
    Copyright (C) 2011  Pavel Prochazka

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "MG_lib.h"
#include "WRMS_include.h"

static SPRITE *_crosshair = NULL;

SPRITE *
WRMS_crosshair_update (SPRITE * gun)
{
  VECTOR angle = WRMS_gun_get_angle (gun);

  POINT gun_mid = sprite_mid (gun);

  if (!_crosshair)
    {
      char *name = WRMS_build_name (-1, -1, "crosshair", WRMS_PIXMAP_SUFFIX);
      _crosshair = MG_make_sprite (MG_get_img (name), NULL);
      _crosshair->type = CROSSHAIR;
      free (name);
      MG_attach_sprite (gun, _crosshair, 0, 0);
      MG_set_key (_crosshair, "gun", gun);
    }

  POINT dst = point_from_vector (angle, 48);

  MG_sprite_set_position (_crosshair,
			  gun_mid.x + dst.x - (_crosshair->dest.w / 2),
			  gun_mid.y + dst.y - (_crosshair->dest.h / 2));
  return _crosshair;
}

void
WRMS_crosshair_unset ()
{
  if (!_crosshair)
    return;

  MG_detach_sprite ((SPRITE *) MG_get_key (_crosshair, "gun"), _crosshair);
  MG_remove_sprite (_crosshair);

  _crosshair = NULL;
}

void
WRMS_crosshair_clear ()
{
  _crosshair = NULL;
}

SPRITE *
WRMS_crosshair ()
{
  return _crosshair;
}
