/*
    Bazoo_worms the game
    Copyright (C) 2011  Pavel Prochazka

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "WRMS_include.h"

WORM_STATES
WRMS_worm_move_controll (SPRITE * self)
{
  WRMS_worm *w = WRMS_get_worm_desc (self);
  WORM_STATES out = w->worm_state;

  switch (w->player_spec.player_type)
    {
    case WRMS_HUMAN:
      if (MG_key_down_p (SDLK_RIGHT))
	{
	  out.direction = RIGHT;
	  out.action = MOVING;
	}
      else if (MG_key_down_p (SDLK_LEFT))
	{
	  out.direction = LEFT;
	  out.action = MOVING;
	}
      else if (MG_key_down_p (SDLK_RETURN) && out.action != JUMPING)
	{
	  out.action = JUMPING;
	}
      else
	{
	  out.action = IDLING;
	}
      break;
    case WRMS_COMPUTER:
      WRMS_ai_micro_brain (self, &out, 0);
      break;
    default:
      printf ("ERROR: Unknown worm type\n");
      break;
    }

  return out;
}

void
WRMS_worm_controll_gun (SPRITE * self)
{
  WRMS_worm *w = WRMS_get_worm_desc (self);
  SPRITE *gun = WRMS_worm_get_gun (self);
  DIRECTION dir = WRMS_gun_get_direction (gun);
  int _space_toggle = w->space_toggle;

  int change_p = 0;

  switch (w->player_spec.player_type)
    {
    case WRMS_HUMAN:
      if (MG_key_down_p (SDLK_UP))
	{
	  WRMS_gun_set_angle (gun, WRMS_gun_increase_angle (gun), dir);
	  change_p = 1;
	}
      else if (MG_key_down_p (SDLK_DOWN))
	{
	  WRMS_gun_set_angle (gun, WRMS_gun_decrease_angle (gun), dir);
	  change_p = 1;
	}
      else if (MG_key_down_p (SDLK_SPACE))
	{
	  change_p = 1;
	  float b;
	  _space_toggle = 1;

	  if ((b = WRMS_gun_increase_power (gun)) > 1.0f)
	    {
	      printf ("max intensity reached %f\n", b);
	      WRMS_gun_fire (self);
	      _space_toggle = 0;
	    }
	}
      else if (_space_toggle == 1)
	{
	  change_p = 1;
	  WRMS_gun_fire (self);
	  _space_toggle = 0;
	}

      break;
    case WRMS_COMPUTER:
      change_p = WRMS_ai_micro_brain (self, NULL, 1);
      break;
    default:
      printf ("ERROR: Unimplemented player type\n");
      break;
    }

  if (change_p)
    WRMS_arrow_unset ();

  w->space_toggle = _space_toggle;
  WRMS_worm_controll_gun_impl (self);
}
