/*
    Bazoo_worms the game
    Copyright (C) 2011  Pavel Prochazka

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef CONFIG_H
#define CONFIG_H

/* magic values */
#define WRMS_WORLD_SCREEN rect( 0 , 0 , 2048 , 1600 )
#define MENU_MAX_TEAMS 20

#define ARROW_TTL 4000

#define ENV_PHYSICS vector( 0.0f , 0.00025f )

#define WIND_MAX_POWER 0.000333333f
#define WRMS_FONT "ubuntu.ttf"
#define WRMS_FONT_MENU_COLOR color( 192 , 0 , 12 )
#define WRMS_PIXMAP_SUFFIX "bmp"
#define WRMS_ANIMATION_SUFFIX NULL
#define WRMS_AUDIO_SUFFIX "wav"
#define WRMS_TIMING 30
#define ANGLE_STEP 0.10f
#define TEAM_MAX_COUNT 4
#define TEAMMATES_MAX_COUNT 4
#define POWER_STEP 0.05f

#define WRMS_AI_DAMAGE_THRESHOLD 20.0f

#define ERROR_DIALOG_WIDTH 400
#define ERROR_DIALOG_HEIGHT 200
#define YESNO_DIALOG_WIDTH 400
#define YESNO_DIALOG_HEIGHT 200

#define KEY_REPEAT 300
#define TIMER_FUNC_TYPE void (*)(SPRITE * self, void * args)
#define CLOCK_TEXT_COLOR color( 248 , 18 , 0 )
#define DIALOG_COLOR color( 0 , 0 , 36 )
#define DIALOG_BORDER_COLOR color( 0 , 0 , 16 )
#define DIALOG_TITLE_COLOR color( 255 , 255 , 255 )

#define EDITABLE_TEXT_INACTIVE color( 255 , 255 , 255 )
#define EDITABLE_TEXT_ACTIVE color( 255 , 189 , 64 )
#define EDITABLE_TEXT_SIZE 18

#define WRMS_DIALOG_W 800
#define WRMS_DIALOG_H 600

#define WRMS_TEAM_MAX_CHARS 25
#define BAZOO_MAX_OUT_OF_SCREEN 256

#define TEAM_WIN_STR "Team: %s won this round!"

#define IMPLICIT_CONF "(:teams ((:name inf08 :type HUMAN :teammates (beerd dohnad matonoht vavrusar)) (:name niemands :type AI :teammates (niemand1 niemand2 niemand3 niemand4 ))))"

#define UNTITLED_TEAM "(:name untitled_team :type AI :teammates (untitled1 untitled2 untitled3 untitled4))"

#define CONF_PATH "/.bazoo_worms.conf"
#define IMPLICIT_GAME_CONF "(:fonts (ubuntu.ttf) :images (arrow.png bazooka_left.bmp cloud.bmp check.bmp worm_idling_left.bmp worm_moving_left.bmp background.png bazooka_right.bmp crosshair.bmp menu_background.png worm_idling_right.bmp worm_moving_right.bmp bazoobullet_left.bmp firepower.bmp myface.png wind_ind_left.bmp worm_jumping_left.bmp bazoobullet_right.bmp boom.bmp grave.bmp proceed.bmp wind_ind_right.bmp worm_jumping_right.bmp bazooexplosion.bmp button.png hud_bckg.bmp sea.png worm_idle.bmp worm_move_right.bmp))"

#define DIALOG_WIDTH WRMS_get_screen_w()*(0.6)
#define DIALOG_HEIGHT WRMS_get_screen_h()*(0.55)
#define DIALOG_ALIGN_TOP( sprite ) (WRMS_get_screen_h()/2)-(sprite->dest.h/2)
#define DIALOG_ALIGN_LEFT( sprite ) 300+(sprite->dest.w/28)

#define MAP_LIST "(tropical.png)"

#endif
