/*
    Bazoo_worms the game
    Copyright (C) 2011  Pavel Prochazka

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef WRMS_utils_H
#define WRMS_utils_H

SDL_Rect rect (int x, int y, int w, int h);
int rect_cmp (SDL_Rect r1, SDL_Rect r2);

SDL_Color color (Uint8 r, Uint8 g, Uint8 b);
int *make_int (int i);

double rad_to_degrees (double rad);
double deg_to_radians (double deg);
VECTOR vector (float x, float y);
double vector_angle (VECTOR v);
VECTOR vector_normalize (VECTOR v, float len);
VECTOR vector_from_points (POINT p1, POINT p2);

void vector_print (VECTOR v);

POINT point_from_vector (VECTOR v, int len);
double points_distance (POINT p1, POINT p2);
POINT sprite_mid (SPRITE * s);
void sprite_align_mid (SPRITE * to_align, SPRITE * source);
VECTOR rotate_vector (VECTOR v, double rad);

void print_rect (SDL_Rect r);
SDL_Rect rects_cut (SDL_Rect r1, SDL_Rect r2);
SDL_Rect screen_rect ();
void sprite_clear_surface (SPRITE * s);

int pixel_in_rect_p (SDL_Rect r, POINT pix);

POINT pixel_perfect_collision_p (SPRITE * worm, SPRITE * landscape);
float vector_length (VECTOR v);

Uint32 get_pixel_from_sprite (SPRITE * s, POINT pix, int *err_p);
int pixel_collide_sprite_p (SPRITE * s, POINT pix);

SDL_Surface *render_text (const char *text, SDL_Color color, Uint8 size,
			  const char *font);
void WRMS_font_cache_clear ();
//TTF_Font * font_from_cache( const char * text , Uint8 size );
SPRITE *WRMS_text (const char *text, SDL_Color color, Uint8 size,
		   const char *font);

SDL_Surface *surface_new (Uint32 width, Uint32 height, Uint32 surf_flags);
SDL_Surface *surface_make_rect (int w, int h, SDL_Color background_color,
				SDL_Color border_color, int border_width);


char *file_read (const char *path);
char *WRMS_parent_path (const char *path);

#define MIN(a,b)(a < b ? a : b)
#define MAX(a,b)(a > b ? a :b)

SDL_Surface *surface_scale (SDL_Surface * in, int w, int h);

#endif
