/*
    Bazoo_worms the game
    Copyright (C) 2011  Pavel Prochazka

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef WRMS_INCLUDE_H
#define WRMS_INCLUDE_H

#include "SDL/SDL.h"
#include "MG_lib.h"
#include "config.h"

#define LIST NODE


typedef enum
{
  UNKNOWN = 0x0,
  BACKGROUND,
  LANDSCAPE,
  WATER,
  WORM,
  GUN,
  HUD,
  BONUS,
  CROSSHAIR,
  BULLET
} WRMS_types;

typedef enum
{
  DIR_UNKNOWN = -1,
  LEFT,
  TOP,
  RIGHT,
  BOTTOM
} DIRECTION;

typedef enum
{
  NOTHING = -1,
  MOVING = 0,
  JUMPING,
  FIRING,
  IDLING,
  BORED,
  EXPLOSING,
  DYING
} ACTION;



void WRMS_enter_rendering ();
int WRMS_load_map (const char *path);

char *WRMS_build_name (DIRECTION direction, ACTION action, const char *prefix,
		       const char *suffix);

typedef struct WORM_STATES
{
  DIRECTION direction;
  ACTION action;

} WORM_STATES;

#include "arrow.h"
#include "landscape.h"
#include "menu.h"
#include "wind.h"
#include "WRMS_utils.h"

void WRMS_landscape_free_surface ();

int WRMS_init_system (const char *confpath);
int WRMS_deinit_system ();

#include "background.h"
#include "crosshair.h"
#include "worm.h"
#include "weapon.h"
#include "bullet.h"
#include "rules.h"
#include "controll.h"
#include "visualizer.h"
#include "hud.h"

SPRITE *WRMS_player_make (const char *name, WRMS_team * team, int begins_p);
char *WRMS_player_name (SPRITE * worm);

void WRMS_ai_reset ();

#endif
