//Funkce podle NBC vybira hrany, ktere se zneprujezdni. Pocet techto hran je dan
//promennou "vypusteno". Vystupem je vektor zneprujezdnenych hran a matice novych vzdalenosti.

function [x,vzdal_nove]=vynechanihrany(vypusteno,NBC)
global hrany vzdal

//Pocatecni nastaveni promennych.
x=[];                        //pocet jiz vypustenych hran
i=1;
vzdal_nove=vzdal;
kontrola=[];

while length(x)<vypusteno
    
    //Podle NBC vygenerujeme hranu, kterou zneprujezdnime

    b=cumsum(NBC);               //kumulativni cetnost normovaneho betweenness indexu
    generovani=rand(1,1);
    vybrana_hrana=find(b>=generovani,1);

    //kontrola, jestli vybrana hrana neni jiz ve vektoru "x"

    kontrola=(find(vybrana_hrana==x));

    //pokud hrana jeste nebyla vypustena, najde se v mnozine hran a vypusti se

    if length(kontrola)==0 then
        x(i)=vybrana_hrana;
        h=find(hrany==x(i));
        vzdal_nove(h)=%inf;
        i=i+1;
    end;

    kontrola=[];

end;

endfunction;

