//Funkce simulovaneho zihani, ktera pracuje s vymenou klesajiciho poctu hran
//v mnozine neprujezdnych hran. Vymen hran je ovlivnen NBC. Vystupem funkce je
//nejmensi smerodatna odchylka počtu obyvatel v komponentach, ji odpovidajici
//mnozina neprujezdnych hran a pocet komponent, na ktere rozpadla.

function [x_best,smer_odchylka_x_best,pocet_x_best]=simulovanezihani5(vypusteno,T0,iterace)

//Vypocet normovaneho betweenness indexu pro danou sit.
[NBC]=betweenness(vzdal);

//Ulozeni neprujezdnych hran a novych vzdalenosti po vynechani "x" hran.
[x,vzdal_nove]=vynechanihrany(vypusteno,NBC);

//Zjisteni poctu komponent, na ktere se sit rozpadla po vynechani "x" hran.
//Vypocet smerodatne odchylky pro novou mnozinu prujezdnych hran.
[pocet_komp,smer_odchylka]=prohledavani(vzdal_nove,vypusteno);

//Nastaveni puvodnich hodnot jako nejlepsi.

x_best=x;                           //mnozina neprujezdnych hran
pocet_x_best=pocet_komp;            //pocet komponent
smer_odchylka_puv=smer_odchylka;    //smerodatna odchylka poctu obyvatel
smer_odchylka_x_best=smer_odchylka; //nejmensi smerodatna odchylka poctu obyvatel
vzdal_arch=vzdal_nove;              //vzdalenosti

//Nastaveni koncove a pocatecni teploty.

T_konec=1;
T=T0;

//Urceni, po kolika stupnich se pocet vymenovanych hran snizi.
T_upravene=round(T0/vypusteno);

vypusteno_puvodni=vypusteno;    //ulozeni puvodniho poctu neprujezdnych hran

//Opakovany vypocet
for i=1:vypusteno_puvodni
    
    T_konec=T-T_upravene    //upravena koncova teplota
    
    //Simulace algoritmu simulovaneho zihani.
    while T>T_konec & T>0
        
        //Metropolisuv algoritmus
        
        for k=1:iterace
            vzdal_nove=vzdal_arch;
            
            //Vymena urciteho poctu hran podle NBC. Počet je dan pravdepodobnosti vyberu.
            [vzdal_nove1,x1]=hrany_sestupne(vzdal_nove,x,vypusteno)
            [pocet_komp,smer_odchylka]=prohledavani(vzdal_nove1,vypusteno_puvodni);

            //Metropolisovo kriterium
            delta=smer_odchylka-smer_odchylka_puv;

            //Overeni, jestli je nova smer. odchylka mensi nez puvodni
        
            if delta<0 then
                pocet_x=pocet_komp;
                x=x1;
                vzdal_arch=vzdal_nove1;
                smer_odchylka_puv=smer_odchylka;
            
                //porovnani, jestli je smer. odchylka mensi nez doposud zjistena nejmensi smer. odchylka
                if smer_odchylka<smer_odchylka_x_best then
                
                    //ulozeni nove nejlepsi smerodatne odchylky
                    smer_odchylka_x_best=smer_odchylka;
                    //ulozeni vzdalenosti
                    vzdal_best=vzdal_arch;
                    //ulozeni vektoru neprujezdnych hran a poctu komponent
                    x_best=x1;
                    pocet_x_best=pocet_komp;
                end;
            
            //nova smerodatna odchylka poctu obyvatel neni mensi nez puvodni
        
            else r=rand(1,1);      //generovani nahodneho cisla z intervalu (0,1)
        
            //pokud je splnena podminka, prijimame i toho zhorsujici reseni
        
                if r<exp(-delta/T) then
                    pocet_x=pocet_komp;
                    x=x1;
                    vzdal_arch=vzdal_nove1;
                    smer_odchylka_puv=smer_odchylka;
                end;
            end;
        end;
            T=T-1;                                              //snizeni teploty o 1 stupen
    end;
    T=T_konec;
    vypusteno=vypusteno-1;
end;
endfunction;



