//Funkce hrany_pst vymenuje v mnozine neprujezdnych hran variabilni pocet hran.
//Pocet hran je urcen stanovenou pravdepodobnosti vyberu. Vystupem funkce jsou 
//nove vzdalenosti (vzdal_nove1) a nova mnozina neprujezdnych hran (x1).

function [vzdal_nove1,x1]=hrany_pst(vzdal_nove,x,vypusteno,p_st_cela,pocet)
global hrany vzdal

//Ulozeni prujezdnych hran.
prujezdne_hrany_x=hrany(find(vzdal_nove~=%inf));

m=1;

//Nacteme hodnoty normovaneho betweenness indexu a spocitame kumulativni
//cetnosti.

[NBC]=betweenness(vzdal_nove);
b1=cumsum(NBC);

x1=[];      //nova neprujezdna hrana

//Generovani nahodneho cisla z intervalu (0,1)
nahoda=rand(1,1);

//Podle nahodneho cisla urcime pocet hran, ktere se budou v mnozine neprujezdnych hran menit
pocet_hran=find(p_st_cela>=nahoda,1);

while length(x1)<pocet_hran
    
    //Zneprujezdneni poctu hran, stanoveneho pravdepodobnosti vyberu.
    
    nh=[];                       //nova neprujezdna hrana
    kontrola=[];

    while nh==[]
    
        //Zneprujezdnime jednu hranu podle NBC. Overime, jestli vybrana hrana
        //neni jiz ve vektoru neprujezdnych hran.

        generovani1=rand(1,1);
        d1=find(b1>=generovani1,1);
        kontrola=(find(d1==x));

        if length(kontrola)==0 then
 
            //Pokud byla ve vektoru prujezdnych hran, zneprujezdnime ji.

            nh=d1;
            vyskyt=0;
        end;
    end;

    for p=1:m-1
        
        //Kontrola, jestli jsme jiz danou hranu nezneprujezdnili v predchozim kroku.
            
        if nh==x1(p) then
            vyskyt=1;
        end;
    end;

    if vyskyt==0 then
        
        //Pokud hrana doposud neni ve vektoru zneprujezdnenych hran, nastavime
        //jeji vzdalenost na nekonecno.
        
        x1(m)=nh;
        hr=find(hrany==x1(m));
        vzdal_nove(hr)=%inf;
        m=m+1;
    end;
end;

prujezdne_hrany_x1=[];
n=1;

while length(prujezdne_hrany_x1)<pocet_hran
    
    //Zprujezdneni puvodnich neprujezdnych hran.
    
    nahoda2=fix(pocet_hran*rand(1))+1;  //pozice hrany v mn. neprujezdnych hran,
                                        //ktera se zprujezdni
    if x(nahoda2)~=prujezdne_hrany_x1 then
        
        //Hrana jeste nebyla zprujezdnena, zprujezdni se.
        
        prujezdne_hrany_x1(n)=x(nahoda2);
        hr=find(hrany==prujezdne_hrany_x1(n));
        vzdal_nove(hr)=vzdal(hr);
        n=n+1;
    else
        n=n;
    end;
end;

//Ulozeni novych vzdalenosti.
vzdal_nove1=vzdal_nove; 

neprujezdne_hrany=hrany(find(vzdal_nove==%inf));
x1=[];
for i=1:length(neprujezdne_hrany)
    
    //Zjisteni noveho vektoru neprujezdnych hran.
    if neprujezdne_hrany(i)~=x1 then
        x1_1=neprujezdne_hrany(i);
        x1=[x1;x1_1];
    end;
end;
x=x1;
endfunction
