//Zakladni program, ve kterem uzivatel zvoli potrebne parametry a urci si metodu, ktera
//se pouzije. Po zadani parametru a metody se spusti program s vybranou metodou. Vysledkem
//je vypsani vektoru zneprujezdnenych hran, poctu komponent, na ktere se sit rozpadla
//a smerodatne odchylky poctu obyvatel zijicich v techto komponentach.

//Pouzite parametry:
//ukaz          index vrcholu
//nasl          seznam nasledniku vrcholu
//vzdal         vzdalenost mezi vrcholy
//hrany         oznaceni hran mezi vrcholy
//obyv          pocet obyvatel ve vrcholech
//vypusteno     pocet zneprujezdnenych hran
//T0            pocatecni teplota
//iterace       pocet opakovani algoritmu pred snizenim teploty
//x_best        vektor zneprujezdnenych hran
//smer_odchylka_x_best      nejmensi zjistena smerodatna odchylka poctu obyvatel v komponentach
//pocet_x_best      pocet komponent po zneprujezdneni hran ve vektoru x_best

clear

//Nacteme vsechny funkce, ktere jsou v prubeho algoritmu potrebne (je nutne upravit cesty).
exec('C:\Users\Pavlinka\Desktop\UPOL\SCILAB\dolezelova_vsechno\simulovane_zihani1.sce', 0);
exec('C:\Users\Pavlinka\Desktop\UPOL\SCILAB\\dolezelova_vsechno\simulovane_zihani2.sce', 0);
exec('C:\Users\Pavlinka\Desktop\UPOL\SCILAB\\dolezelova_vsechno\simulovane_zihani3.sce', 0);
exec('C:\Users\Pavlinka\Desktop\UPOL\SCILAB\\dolezelova_vsechno\simulovane_zihani4.sce', 0);
exec('C:\Users\Pavlinka\Desktop\UPOL\SCILAB\\dolezelova_vsechno\simulovane_zihani5.sce', 0);
exec('C:\Users\Pavlinka\Desktop\UPOL\SCILAB\\dolezelova_vsechno\NACTIDATA.sci', -1);
exec('C:\Users\Pavlinka\Desktop\UPOL\SCILAB\\dolezelova_vsechno\betweenness.sce', 0);
exec('C:\Users\Pavlinka\Desktop\UPOL\SCILAB\\dolezelova_vsechno\vynechani_hrany.sce', 0);
exec('C:\Users\Pavlinka\Desktop\UPOL\SCILAB\\dolezelova_vsechno\prohledavani.sce', 0);
exec('C:\Users\Pavlinka\Desktop\UPOL\SCILAB\\dolezelova_vsechno\hrany1_1.sce', 0);
exec('C:\Users\Pavlinka\Desktop\UPOL\SCILAB\\dolezelova_vsechno\hranyvsechny.sce', 0);
exec('C:\Users\Pavlinka\Desktop\UPOL\SCILAB\\dolezelova_vsechno\hrany_pst.sce', 0);
exec('C:\Users\Pavlinka\Desktop\UPOL\SCILAB\\dolezelova_vsechno\nahoda_hrany.sce', 0);
exec('C:\Users\Pavlinka\Desktop\UPOL\SCILAB\\dolezelova_vsechno\hrany_sestupne.sce', 0);

global ukaz nasl vzdal hrany obyv
stacksize("max")

//Nacteni informaci o grafu
sit=mopen('C:\Users\Pavlinka\Desktop\UPOL\SCILAB\dolezelova_vsechno\zlin_cast1_trb.txt');
disp('Nacitam data.');
NACTIDATA(sit);
mclose(sit);
disp(" ");

//Zadani vstupnich parametru.
vypusteno = input("Pocet zneprujezdnenych hran: ");
T0 = input("Pocatecni teplota: ");
iterace = input("Pocet opakovani v dane teplote: ");

//Zvoleni verze simulovaneho zihani.
disp(" ");
disp("Vyberte verzi simulovaneho zihani (1-5)");
disp("1 - simulovane zihani 1 - vymena jedne hrany");
disp("2 - simulovane zihani 2 - vymena vsech hran");
disp("3 - simulovane zihani 3 - vymena podle p-st");
disp("4 - simulovane zihani 4 - vymena nahodneho poctu hran");
disp("5 - simulovane zihani 5 - vymena snizujiciho poctu hran");
disp(" ");
a = input("Zvolena verze simulovaneho zihani: ");
disp(" ");
disp("Probiha vypocet.");

select a
    case 1 then
        [x_best,smer_odchylka_x_best,pocet_x_best]=simulovanezihani1(vypusteno,T0,iterace)
    case 2 then
        [x_best,smer_odchylka_x_best,pocet_x_best]=simulovanezihani2(vypusteno,T0,iterace)
    case 3 then
        [x_best,smer_odchylka_x_best,pocet_x_best]=simulovanezihani3(vypusteno,T0,iterace)
    case 4 then
        [x_best,smer_odchylka_x_best,pocet_x_best]=simulovanezihani4(vypusteno,T0,iterace)
    case 5 then
        [x_best,smer_odchylka_x_best,pocet_x_best]=simulovanezihani5(vypusteno,T0,iterace)
end;

disp("Vypocet je u konce. Vysledky jsou:");
disp(" ");

//Vypsani vysledku
disp("Vektor zneprujezdnenych hran: ");
disp(x_best)
disp("Nejmensi smerodatna odchylka: "+string(smer_odchylka_x_best));
disp("Pocet komponent: "+string(pocet_x_best));
