//Funkce hranyvsechny vymenuje generuje novou celou mnozinu neprujezdnych hran.
//Vystupem funkce jsou nove vzdalenosti (vzdal_nove1) a nova mnozina neprujezdnych hran (x1).

function [vzdal_nove1,x1]=hranyvsechny(vzdal_nove,vypusteno)
global hrany vzdal
vzdal_prvni=vzdal;
//Ulozeni prujezdnych hran.
prujezdne_hrany_x=hrany(find(vzdal_nove~=%inf));

m=1;

//Nacteme hodnoty normovaneho betweenness indexu a spocitame kumulativni
//cetnosti.

[NBC]=betweenness(vzdal_nove);
b1=cumsum(NBC);

x1=[];      //nova neprujezdna hrana
    
while length(x1)<vypusteno
    
    //Zneprujezdneni poctu hran, stanoveneho pravdepodobnosti vyberu.
    
    nh=[];                       //nova neprujezdna hrana
    kontrola=[];

    while nh==[]
    
        //Zneprujezdnime jednu hranu podle NBC. Overime, jestli vybrana hrana
        //neni jiz ve vektoru neprujezdnych hran.

        generovani1=rand(1,1);
        d1=find(b1>=generovani1,1);
        kontrola=(find(d1==x));

        if length(kontrola)==0 then
 
            //Pokud byla ve vektoru prujezdnych hran, zneprujezdnime ji.

            nh=d1;
            vyskyt=0;
        end;
    end;

    for p=1:m-1
        
        //Kontrola, jestli jsme jiz danou hranu nezneprujezdnili v predchozim kroku.
            
        if nh==x1(p) then
            vyskyt=1;
        end;
    end;

    if vyskyt==0 then
        
        //Pokud hrana doposud neni ve vektoru zneprujezdnenych hran, nastavime
        //jeji vzdalenost na nekonecno.
        
        x1(m)=nh;
        hr=find(hrany==x1(m));
        vzdal_prvni(hr)=%inf;
        m=m+1;
    end;
end;

//Ulozeni novych vzdalenosti.
vzdal_nove1=vzdal_prvni;

endfunction
