//Funkce hrany1_1 vymenuje v mnozine neprujezdnych hran prave jednu hranu z teto
//mnoziny. Vystupem funkce jsou nove vzdalenosti (vzdal_nove1) a nova mnozina
//neprujezdnych hran (x1).

function [vzdal_nove1,x1]=hrany1_1(vzdal_nove,x,NBC)
global hrany vzdal

//Ulozeni prujezdnych hran.
prujezdne_hrany_x=hrany(find(vzdal_nove~=%inf));

//Nacteme hodnoty normovaneho betweenness indexu a spocitame kumulativni
//cetnosti.

[NBC]=betweenness(vzdal_nove);
b1=cumsum(NBC);

nh=[];                       //nova neprujezdna hrana
kontrola=[];
while nh==[]
    
    //Zneprujezdnime jednu hranu podle NBC. Overime, jestli vybrana hrana
    //neni jiz ve vektoru neprujezdnych hran.

    generovani1=rand(1,1);
    d1=find(b1>=generovani1,1);
    kontrola=(find(d1==x));

    if length(kontrola)==0 then
 
        //Pokud byla ve vektoru prujezdnych hran, zneprujezdnime ji.

        nh=d1;
    end;
end;

//Najdeme puvodni oznaceni zneprujezdnenych hran a nastavime ji novou
//vzdalenost nekonecno.

hr=find(hrany==nh);
vzdal_nove(hr)=%inf;

prujezdne_hrany_x1=[];
kontrola2=[];
while prujezdne_hrany_x1==[]

    //Nahodne vygenerujeme hranu, kterou bychom mohli zprujezdnit.

    generovani2=rand(1,1);
    generovani2=generovani2*(length(hrany)/2);
    generovani2=fix(generovani2);

    //Overime, jestli je vygenerovana hrana ve vektoru puvodnich neprujezdnych
    //hran.
    kontrola2=(find(generovani2==x));

    if length(kontrola2)==1 then

        //Vygenerovanou hranu zprujezdnime a priradime ji puvodni vzdalenost.

        prujezdne_hrany_x1=generovani2;
        hra=find(hrany==prujezdne_hrany_x1);
        vzdal_nove(hra)=vzdal(hra);
    end;
end;

//Ulozeni noveho vektoru neprujezdnych hran.
x1=setdiff(x,prujezdne_hrany_x1);
x1(vypusteno)=nh;

//Ulozeni novych vzdalenosti.
vzdal_nove1=vzdal_nove;
endfunction
