//Funkce vraci normovany betweenness index pro kazdou hranu (NBC) spocitany pomoci Dijkstrova algoritmu.

function[NBC]=betweenness(vzdal);
global ukaz nasl hrany

B=zeros(length(hrany)/2,1);//Pole cetnosti vyskytu hran (indexy) na nejkratsich cestach.

for i=1:(length(ukaz)-1) do
    
    //Inicialize matice nejkratsich cest.     
    
    //Cisla radku = cisla uzlu
    //Prvni radek-delka dosud nejkratsi zname cesty, druhy radek-informace
    //o tom, zda lze jeste najit nejkratsi cestu (0) nebo ne (1), treti radek-
    //cislo predchoziho uzlu na doposud zname nejkratsi ceste, ctvrty radek - cislo 
    //posledni hrany na doposud zname nejkratsi ceste.
    dt=zeros(4,(length(ukaz)-1));
    dt(1,1:(length(ukaz)-1))=%inf;
    dt(1,i)=0;

    //Dijkstruv algoritmus pro vypocet nejkratsi cesty
    
    true=1;
    while(true==1) do
        
        //Zjistime polohy uzlu, u kterych jeste nezname nejkratsi cestu.
        //Pokud zname vsechny nejkratsi cesty, tak skoncime.
        
        pom_doc=find(dt(2,:)==0);    
        if(size(pom_doc,2)==0)      
            true=0;
        else
            
            //Najdeme uzel s nejkratsi cestou, ktera jeste nebyla konecna, a prohlasime
            //ji za konecnou.
            
            [min1 poloha]=min(dt(1,pom_doc)); 
            koren=pom_doc(poloha);
            dt(2,koren)=1;      
            
            //Prepocteme nejkratsi cesty do vsech uzlu, do kterych nevedou konecne 
            //nejkratsi cesty a ktere vedou pres uzel ulozeny v promenne koren.
             
            if(dt(1,koren)<%inf)
                for j=ukaz(koren):ukaz(koren+1)-1
                    if (dt(2,nasl(j))~=1)
                        if(dt(1,koren)+vzdal(j)<dt(1,nasl(j)))
                            dt(1,nasl(j))=dt(1,koren)+vzdal(j);
                            dt(3,nasl(j))=koren;
                            dt(4,nasl(j))=hrany(j);
                        end;
                    end;
                end; 
            else true=0;  
            end;
        end;
    end;

    //Vypocet, kolikrat se vsechny hrany vyskytly na nejkratsi ceste
    //z vrcholu "k" do vsech ostatnich vrcholu.
    
    for k=i+1:(length(ukaz)-1) do
        while k~=i & k~=0 do
            vrchol= dt(3,k);
                if dt(4,k)>0 then
                    B(dt(4,k))=B(dt(4,k))+1;
                end;
            k=vrchol;
        end;
    end;
end;

//Vypocet normovaneho betweenness indexu.

NBC=B/((sum(B)))

endfunction
