import numpy as np
import matplotlib.pyplot as plt
import math

def euler(F,T,Y0,h):
    '''
    F .... 
    T... list/array [t_0,t_f]
    Y0 ... list/array
    '''
    t = np.arange(T[0],T[1],h)
    if t[-1] != T[1]:
        t = np.append(t,T[1])
    t = np.float16(t)
        
    N = np.shape(t)[0]
    Y = np.zeros(shape=(N,1))
    Y[0,:] = Y0
    Y = np.float16(Y)
    
    for i in range(0,N-1):
        Y[i+1,:] = np.float16(Y[i,:] + h*F(t[i],Y[i,:]))
    out = {'t':t,'Y':Y}
    return out

def F(t,X):
    return np.float16(X[0]/t - (X[0]/t)**2)

def exa(x):
    return np.float16(x/(1+np.log(x)))

#tabulka 2.4
M = 9
er = np.zeros(shape=(M,1))
steps = np.zeros(shape=(M,1))
count = np.zeros(shape=(M,1))

for j in range(0,M):
    steps[j] = np.float16(1/(2**(j+1)))
    out = euler(F,T,Y0,steps[j])
    er[j] = abs(out['Y'][-1]-exa(2))
    print('s: '+str(j)+' h_s: '+str(np.round(steps[j],4))+' e: '+str(np.round(er[j],4)))

#obrazek 2.4
plt.plot(steps,er,'-o')
plt.xlabel('krok',fontsize=12)
plt.ylabel('chyba',fontsize=12)
plt.show()

#obrazek 2.5
plt.plot(np.log2(steps),np.log2(er),'-o')
plt.xlabel('log2(h)',fontsize=12)
plt.ylabel('log2(chyba)',fontsize=12)
plt.show()